/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.piscofins.model;

import com.touchcomp.basementorrules.impostos.BaseValoresCalculados;
import com.touchcomp.basementorrules.impostos.piscofins.model.PisCofinsParams;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;

public class PisCofinsCalculado
extends BaseValoresCalculados {
    private Double valorBCCofins = 0.0;
    private Double valorBCPis = 0.0;
    private Double valorBCCofinsST = 0.0;
    private Double valorBCPisST = 0.0;
    private Double valorPis = 0.0;
    private Double valorCofins = 0.0;
    private Double valorPisST = 0.0;
    private Double valorCofinsST = 0.0;
    private Double aliquotaCofins = 0.0;
    private Double aliquotaPis = 0.0;
    private Double aliquotaCofinsST = 0.0;
    private Double aliquotaPisST = 0.0;
    private PisCofinsParams pisCofinsParams;

    private PisCofinsCalculado() {
    }

    public PisCofinsCalculado(PisCofinsParams pisCofinsParams) {
        this();
        this.pisCofinsParams = pisCofinsParams;
    }

    public Double getValorBCCofins() {
        return this.valorBCCofins;
    }

    public void setValorBCCofins(Double valorBCCofins) {
        this.valorBCCofins = this.arredondarNumero(valorBCCofins);
    }

    public Double getValorBCPis() {
        return this.valorBCPis;
    }

    public void setValorBCPis(Double valorBCPis) {
        this.valorBCPis = this.arredondarNumero(valorBCPis);
    }

    public Double getValorPis() {
        return this.valorPis;
    }

    public void setValorPis(Double valorPis, Double valorMinPis) {
        if (valorMinPis < valorMinPis) {
            valorPis = 0.0;
        }
        this.valorPis = this.arrendondar(valorPis);
    }

    public Double getValorCofins() {
        return this.valorCofins;
    }

    public void setValorCofins(Double valorCofins, Double valorMinCofins) {
        if (valorCofins < valorMinCofins) {
            valorCofins = 0.0;
        }
        this.valorCofins = this.arrendondar(valorCofins);
    }

    public Double getValorPisST() {
        return this.valorPisST;
    }

    public void setValorPisST(Double valorPisST, Double valorMinPis) {
        if (valorPisST < valorMinPis) {
            valorPisST = 0.0;
        }
        this.valorPisST = this.arrendondar(valorPisST);
    }

    public Double getValorCofinsST() {
        return this.valorCofinsST;
    }

    public void setValorCofinsST(Double valorCofinsST, Double valorMinCofins) {
        if (valorCofinsST < valorMinCofins) {
            valorCofinsST = 0.0;
        }
        this.valorCofinsST = this.arrendondar(valorCofinsST);
    }

    public Double getAliquotaCofins() {
        return this.aliquotaCofins;
    }

    public void setAliquotaCofins(Double aliquotaCofins) {
        this.aliquotaCofins = this.arrendondar(aliquotaCofins, 4);
    }

    public Double getAliquotaPis() {
        return this.aliquotaPis;
    }

    public void setAliquotaPis(Double aliquotaPis) {
        this.aliquotaPis = this.arrendondar(aliquotaPis, 4);
    }

    public PisCofinsParams getPisCofinsParams() {
        return this.pisCofinsParams;
    }

    public void setPisCofinsParams(PisCofinsParams pisCofinsParams) {
        this.pisCofinsParams = pisCofinsParams;
    }

    public Double getValorBCCofinsST() {
        return this.valorBCCofinsST;
    }

    public void setValorBCCofinsST(Double valorBCCofinsST) {
        this.valorBCCofinsST = valorBCCofinsST;
    }

    public Double getValorBCPisST() {
        return this.valorBCPisST;
    }

    public void setValorBCPisST(Double valorBCPisST) {
        this.valorBCPisST = valorBCPisST;
    }

    public Double getAliquotaCofinsST() {
        return this.aliquotaCofinsST;
    }

    public void setAliquotaCofinsST(Double aliquotaCofinsST) {
        this.aliquotaCofinsST = aliquotaCofinsST;
        this.aliquotaPisST = this.arrendondar(aliquotaCofinsST, 4);
    }

    public Double getAliquotaPisST() {
        return this.aliquotaPisST;
    }

    public void setAliquotaPisST(Double aliquotaPisST) {
        this.aliquotaPisST = this.arrendondar(aliquotaPisST, 4);
    }

    private Double arrendondar(Double vr) {
        return ToolFormatter.arrredondarNumero((Double)vr, (int)2);
    }

    private Double arrendondar(Double vr, Integer casasDec) {
        return ToolFormatter.arrredondarNumero((Double)vr, (int)casasDec);
    }
}

