/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.suframa;

import com.touchcomp.basementorrules.suframa.model.SuframaCalculado;
import com.touchcomp.basementorrules.suframa.model.SuframaParams;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class CompSuframa {
    public static SuframaCalculado calcularSuframa(SuframaParams params) {
        SuframaCalculado calc = new SuframaCalculado(params);
        Short habilitarSuframa = params.getHabilitarSuframa();
        String inscSuframa = params.getInscricaoSuframa();
        Short naoCalculaSuframaModelo = params.getNaoCalcularSuframaModelo();
        Short naoCalculaSuframaProduto = params.getNaoCalcularSuframaProduto();
        Double percSuframaIcms = params.getAliqSuframaIcms();
        Double percSuframaIpi = params.getAliqSuframaIpi();
        Double percSuframaPis = params.getAliqSuframaPis();
        Double percSuframaCofins = params.getAliqSuframaCofins();
        Double bcIcms = params.getBcIcms();
        Double bcIpi = params.getBcIpi();
        Double bcPis = params.getBcPis();
        Double bcCofins = params.getBcCofins();
        if (ToolMethods.isEquals((Object)habilitarSuframa, (Object)1)) {
            if (ToolMethods.isEquals((Object)naoCalculaSuframaModelo, (Object)1) || ToolMethods.isEquals((Object)naoCalculaSuframaProduto, (Object)1)) {
                return calc;
            }
            Double valorSuframaIcms = ToolFormatter.arrredondarNumero((Double)(bcIcms * (percSuframaIcms / 100.0)), (int)2);
            Double valorSuframaPis = ToolFormatter.arrredondarNumero((Double)(bcPis * (percSuframaPis / 100.0)), (int)2);
            Double valorSuframaCofins = ToolFormatter.arrredondarNumero((Double)(bcCofins * (percSuframaCofins / 100.0)), (int)2);
            Double valorSuframaIpi = ToolFormatter.arrredondarNumero((Double)(bcIpi * (percSuframaIpi / 100.0)), (int)2);
            Double valorTotalDescontoSuframa = ToolFormatter.arrredondarNumero((Double)(valorSuframaIcms + valorSuframaPis + valorSuframaCofins + valorSuframaIpi), (int)2);
            Double perc = 0.0;
            if (valorSuframaIcms > 0.0) {
                perc = perc + percSuframaIcms;
            }
            if (valorSuframaPis > 0.0) {
                perc = perc + percSuframaPis;
            }
            if (valorSuframaCofins > 0.0) {
                perc = perc + percSuframaCofins;
            }
            if (valorSuframaIpi > 0.0) {
                perc = perc + percSuframaIpi;
            }
            Double bcTotal = ToolFormatter.arrredondarNumero((Double)bcIcms, (int)2);
            perc = ToolFormatter.arrredondarNumero((Double)(valorTotalDescontoSuframa * 100.0 / bcTotal), (int)4);
            calc.setPercSuframa(perc);
            calc.setValorSuframa(valorTotalDescontoSuframa);
        }
        return calc;
    }
}

