/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.barcode;

import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import lombok.Generated;
import org.apache.commons.validator.routines.checkdigit.EAN13CheckDigit;

public class ToolBarcode {
    public static boolean isCodigoPesavel(String barcode) {
        if (!ToolMethods.isStrWithData(barcode)) {
            return false;
        }
        return barcode.startsWith("2") && barcode.length() == 13;
    }

    public static DadosPesoValor getDados(String barcode) {
        DadosPesoValor d = new DadosPesoValor();
        d.quantidadeValor = 1.0;
        d.codBarras = barcode;
        d.codProduto = barcode;
        if (!ToolBarcode.isCodigoPesavel(barcode)) {
            return d;
        }
        String codigo = barcode.substring(1, 7);
        String valor = barcode.substring(7, 12);
        String prefixo = valor.substring(0, 3);
        String sufixo = valor.substring(3, 5);
        Double valorConv = Double.valueOf(prefixo + "." + sufixo);
        d.codProduto = ToolString.removerZerosAEsquerda(codigo);
        d.quantidadeValor = valorConv;
        return d;
    }

    public static boolean isValEan13(String barcode) {
        EAN13CheckDigit e = new EAN13CheckDigit();
        return e.isValid(barcode);
    }

    public static class DadosPesoValor {
        private Double quantidadeValor;
        private String codProduto;
        private String codBarras;
        private boolean codigoPesavel = false;

        @Generated
        public Double getQuantidadeValor() {
            return this.quantidadeValor;
        }

        @Generated
        public String getCodProduto() {
            return this.codProduto;
        }

        @Generated
        public String getCodBarras() {
            return this.codBarras;
        }

        @Generated
        public boolean isCodigoPesavel() {
            return this.codigoPesavel;
        }
    }
}

