/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.converter.impl;

import com.touchcomp.basementorexceptions.exceptions.impl.formatter.ExcepFormat;
import com.touchcomp.basementortools.constants.EnumConstantsCriteria;
import com.touchcomp.basementortools.tools.converter.impl.OpFinder;
import com.touchcomp.basementortools.tools.converter.impl.RestrictionOption;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class LongOpFinder
implements OpFinder<Long> {
    private Format format;

    public LongOpFinder() {
        this.format = NumberFormat.getIntegerInstance();
    }

    public LongOpFinder(Format format) {
        this.format = format;
    }

    @Override
    public List<RestrictionOption> getRestrictions() {
        ArrayList<RestrictionOption> aux = new ArrayList<RestrictionOption>();
        RestrictionOption opt = null;
        opt = new RestrictionOption();
        opt.setDescription("Igual a");
        opt.setRestriction(EnumConstantsCriteria.EQUAL);
        aux.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Diferente de");
        opt.setRestriction(EnumConstantsCriteria.NOT_EQUAL);
        aux.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Maior que");
        opt.setRestriction(EnumConstantsCriteria.GREATER);
        aux.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Maior igual a");
        opt.setRestriction(EnumConstantsCriteria.GREATER_EQUAL);
        aux.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Menor que");
        opt.setRestriction(EnumConstantsCriteria.LESS);
        aux.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Menor igual a");
        opt.setRestriction(EnumConstantsCriteria.LESS_EQUAL);
        aux.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Entre");
        opt.setRestriction(EnumConstantsCriteria.BETWEEN);
        aux.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Nulo");
        opt.setRestriction(EnumConstantsCriteria.IS_NULL);
        aux.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Nao Nulo");
        opt.setRestriction(EnumConstantsCriteria.IS_NOT_NULL);
        aux.add(opt);
        return aux;
    }

    @Override
    public Format getFormatter() {
        return this.format;
    }

    @Override
    public void setFormatter(Format format) {
        this.format = format;
    }

    @Override
    public Long getDefaultValue() {
        return 0L;
    }

    @Override
    public Long convertValue(String value) {
        if (value == null || "null".equalsIgnoreCase(value) || value.trim().length() == 0) {
            return null;
        }
        if ((value = ToolString.trim(value)).trim().length() == 0) {
            return null;
        }
        try {
            return ((Number)this.format.parseObject(value)).longValue();
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new ExcepFormat((Throwable)ex, Long.class, this.format.toString(), value);
        }
    }

    @Override
    public Long convertStrNativeValue(String value) {
        if (value == null || "null".equalsIgnoreCase(value) || value.trim().length() == 0) {
            return null;
        }
        return Long.valueOf(value);
    }

    @Override
    public String convertValueToString(Long value) {
        if (value == null) {
            return null;
        }
        return this.getFormatter().format(value);
    }

    @Override
    public String convertValueToStringNative(Long value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public Class getConverterClass() {
        return Long.class;
    }

    @Override
    public String getDefaultValueStr() {
        return this.convertValueToStringNative(this.getDefaultValue());
    }

    @Override
    public String getDefaultValueStrNative() {
        return this.convertValueToString(this.getDefaultValue());
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return false;
        }
        return this.getConverterClass().isAssignableFrom(value.getClass());
    }
}

