/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.criptografia;

import com.touchcomp.basementorexceptions.exceptions.impl.criptografia.ExceptionCriptografia;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.mindrot.jbcrypt.BCrypt;

public class ToolCriptografia {
    public static String md5(String senha) throws ExceptionCriptografia {
        String sen = "";
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new ExceptionCriptografia(e, new Object[]{"MD5"});
        }
        BigInteger hash = new BigInteger(1, md.digest(senha.getBytes()));
        sen = hash.toString(16);
        return sen;
    }

    public static String hashBcrypt(String plainText) {
        return BCrypt.hashpw((String)plainText, (String)BCrypt.gensalt());
    }

    public static boolean checkBcrypt(String plainText, String hash) {
        try {
            return BCrypt.checkpw((String)plainText, (String)hash);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String encryptBase64(String pass) {
        String b64encoded = Base64.getEncoder().encodeToString(pass.getBytes());
        String reverse = new StringBuffer(b64encoded).reverse().toString();
        StringBuilder tmp = new StringBuilder();
        int OFFSET = 4;
        for (int i = 0; i < reverse.length(); ++i) {
            tmp.append((char)(reverse.charAt(i) + 4));
        }
        return tmp.toString();
    }

    public static String decrypteBase64(String pass) {
        StringBuilder tmp = new StringBuilder();
        int OFFSET = 4;
        for (int i = 0; i < pass.length(); ++i) {
            tmp.append((char)(pass.charAt(i) - 4));
        }
        String reversed = new StringBuffer(tmp.toString()).reverse().toString();
        return new String(Base64.getDecoder().decode(reversed));
    }

    public static String encrypt(String seed, String pass) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword(seed);
        String encrypted = encryptor.encrypt(pass);
        return encrypted;
    }

    public static String decrypte(String seed, String pass) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword(seed);
        String decrypted = encryptor.decrypt(pass);
        return decrypted;
    }
}

