/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.database;

import com.touchcomp.basementortools.tools.exception.ToolException;

public class ToolDatabase {
    public static EnumConstQueryStatus getDatabaseErrorMessage(Exception ex) {
        for (EnumConstQueryStatus val : EnumConstQueryStatus.values()) {
            if (!ToolException.findMessage(ex, val.errorStr).booleanValue()) continue;
            return val;
        }
        return EnumConstQueryStatus.QUERY_PROBLEMA_DESCONHECIDO_ERRO;
    }

    public static EnumConstQueryStatus getDatabaseErrorMessage(String stackTrace) {
        for (EnumConstQueryStatus val : EnumConstQueryStatus.values()) {
            if (!ToolException.findMessage(stackTrace, val.errorStr).booleanValue()) continue;
            return val;
        }
        return EnumConstQueryStatus.QUERY_PROBLEMA_DESCONHECIDO_ERRO;
    }

    public static enum EnumConstQueryStatus {
        QUERY_FIELD_ALREADY_EXISTS(5, "Campo ja existe", "already exists"),
        QUERY_DUPLICATE_VALUE(6, "Valor ja existe", "duplicate value"),
        QUERY_VIOLATION_PRIMARY(7, "Campo ja existe", "violation of PRIMARY or UNIQUE KEY constraint"),
        QUERY_NOT_FOUND(8, "Exclusao de Campo/Procedure/Trigger que nao existe ou ja foi excluido", "not found"),
        QUERY_NOT_EXISTS(9, "Exclusao de Campo/Procedure/Trigger que nao existe ou ja foi excluido", "not exist"),
        QUERY_PROBLEMA_DESCONHECIDO_ERRO(3, "Avaliar Erro", ""),
        QUERY_OK(1, "", "");

        private final short value;
        private final String descricao;
        private final String errorStr;

        private EnumConstQueryStatus(short valor, String descricao, String errorStr) {
            this.value = valor;
            this.descricao = descricao;
            this.errorStr = errorStr;
        }

        public short getValue() {
            return this.value;
        }

        public static EnumConstQueryStatus get(Object value) {
            for (EnumConstQueryStatus value1 : EnumConstQueryStatus.values()) {
                if (!String.valueOf(value).equalsIgnoreCase(String.valueOf(value1.value))) continue;
                return value1;
            }
            return QUERY_PROBLEMA_DESCONHECIDO_ERRO;
        }

        public String toString() {
            return this.getDescricao();
        }

        public String getDescricao() {
            return this.descricao;
        }

        public String getErrorStr() {
            return this.errorStr;
        }
    }
}

