/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.excel.impl.read;

import com.touchcomp.basementortools.tools.excel.model.ExcelSheet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExcelMapRead {
    private List<Map> data;
    private int startLine = 0;
    private int endLine = 0;
    private char delimiter = (char)59;
    public static final char DELIMITER_DEFAULT = ';';
    public static final int START_LINE_DEFAULT = 0;

    public ExcelMapRead(List<Map> dados) {
        this.data = dados;
    }

    public ExcelSheet read() {
        ExcelSheet ex = new ExcelSheet();
        ex.setName("dados");
        this.setRows(ex);
        return ex;
    }

    private void setRows(ExcelSheet ex) {
        int index = 0;
        HashSet allkeys = new HashSet();
        for (Map map : this.data) {
            Set keys = map.keySet();
            allkeys.addAll(keys);
        }
        ExcelSheet.Row header = ex.newRow(index);
        int cellIndex = 0;
        for (Object key : allkeys) {
            header.newCell(index).setObject(key);
            ++cellIndex;
        }
        for (Map map : this.data) {
            ExcelSheet.Row row = ex.newRow(++index);
            this.setCells(map, allkeys, row);
        }
    }

    private void setCells(Map data, Set allkeys, ExcelSheet.Row row) {
        int i = 0;
        for (Object key : allkeys) {
            ExcelSheet.Cell cell = row.newCell(i);
            cell.setObject(data.get(key));
        }
    }

    public int getStartLine() {
        return this.startLine;
    }

    public ExcelMapRead setStartLine(int startLine) {
        this.startLine = startLine;
        return this;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public ExcelMapRead setDelimiter(char delimiter) {
        this.delimiter = delimiter;
        return this;
    }
}

