/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.map;

import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.tools.map.AuxObjectToMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ToolMap {
    public static List<Map> concatAndSumMaps(List<Map> aux1, List<Map> aux2, String[] keys, String[] toSum) {
        LinkedList<Map> data = new LinkedList<Map>(aux1);
        data.addAll(aux2);
        LinkedList<Map> ret = new LinkedList<Map>();
        for (Map map : data) {
            Optional<Map> found = ret.stream().filter(i -> ToolMap.isEquals(map, i, keys)).findFirst();
            if (found.isPresent()) {
                Map f = found.get();
                ToolMap.sumMaps(f, map, toSum);
                continue;
            }
            ret.add(map);
        }
        return ret;
    }

    public static boolean isEquals(Map map, Map map2, String[] keys) {
        if (keys.length == 0) {
            return false;
        }
        boolean ret = true;
        for (String key : keys) {
            Object obj1 = map.get(key);
            Object obj2 = map2.get(key);
            boolean bl = ret = ret && Objects.equals(obj2, obj1);
            if (!ret) break;
        }
        return ret;
    }

    public static void sumMaps(Map map, Map map2, String[] toSum) {
        for (String key : toSum) {
            Object obj1 = map.get(key);
            Object obj2 = map2.get(key);
            if (obj1 == null || !(obj1 instanceof Number) || obj2 == null || !(obj2 instanceof Number)) continue;
            Number n1 = (Number)obj1;
            Number n2 = (Number)obj2;
            Double sum = n1.doubleValue() + n2.doubleValue();
            if (Short.class.isAssignableFrom(obj1.getClass())) {
                map.put(key, ((Number)sum).shortValue());
                continue;
            }
            if (Integer.class.isAssignableFrom(obj1.getClass())) {
                map.put(key, ((Number)sum).intValue());
                continue;
            }
            if (Float.class.isAssignableFrom(obj1.getClass())) {
                map.put(key, Float.valueOf(((Number)sum).floatValue()));
                continue;
            }
            if (Double.class.isAssignableFrom(obj1.getClass())) {
                map.put(key, Double.valueOf(sum));
                continue;
            }
            if (Long.class.isAssignableFrom(obj1.getClass())) {
                map.put(key, ((Number)sum).longValue());
                continue;
            }
            map.put(key, sum);
        }
    }

    public static Map get(Map base, List<Map> dados, String ... keys) {
        for (Map dado : dados) {
            int count = 0;
            for (String key : keys) {
                Object value1;
                Object value = base.get(key);
                count += Objects.equals(value, value1 = dado.get(key)) ? 1 : 0;
            }
            if (count != keys.length) continue;
            return dado;
        }
        return null;
    }

    public static List<Map> toMap(List input) throws ExceptionReflection {
        return new AuxObjectToMap(new HashMap<String, Boolean>()).toMap(input);
    }

    public static Map toMap(Object obj) throws ExceptionReflection {
        return new AuxObjectToMap(new HashMap<String, Boolean>()).toMap(obj);
    }

    public static Collection<Map> toMap(Collection<Object> obj) throws ExceptionReflection {
        return new AuxObjectToMap(new HashMap<String, Boolean>()).toMap(obj);
    }

    public static List<Map> toMap(List input, HashMap<String, Boolean> optionsExport) throws ExceptionReflection {
        return new AuxObjectToMap(optionsExport).toMap(input);
    }

    public static Map toMap(Object obj, HashMap<String, Boolean> optionsExport) throws ExceptionReflection {
        return new AuxObjectToMap(optionsExport).toMap(obj);
    }

    public static Collection<Map> toMap(Collection<Object> obj, HashMap<String, Boolean> optionsExport) throws ExceptionReflection {
        return new AuxObjectToMap(optionsExport).toMap(obj);
    }

    public static List<Map> resumeMaps(List<Map> input) {
        LinkedList<Map> ret = new LinkedList<Map>();
        ToolMap.resumeMaps(null, input, ret);
        return ret;
    }

    private static void resumeMaps(Map parent, List<Map> input, List<Map> ret) {
        for (Map mapInp : input) {
            List<List> data = ToolMap.getListsCaseExists(mapInp);
            if (parent != null) {
                Set keys = parent.keySet();
                for (Object key : keys) {
                    mapInp.putIfAbsent(key, parent.get(key));
                }
            }
            if (!data.isEmpty()) {
                List<Map> resumedOneMap = ToolMap.resumeOneMap(data);
                ToolMap.resumeMaps(mapInp, resumedOneMap, ret);
                continue;
            }
            ret.add(mapInp);
        }
    }

    private static List<Map> resumeOneMap(List<List> data) {
        Collections.sort(data, new Comparator<List>(){

            @Override
            public int compare(List o1, List o2) {
                return Integer.valueOf(o1.size()).compareTo(o2.size());
            }
        });
        List bigestList = data.get(0);
        for (Map temp : bigestList) {
            for (int i = 1; i < data.size(); ++i) {
                List aux = data.get(i);
                for (Map m : aux) {
                    temp.putAll(m);
                }
            }
        }
        return bigestList;
    }

    private static List<List> getListsCaseExists(Map mapInp) {
        Set keys = mapInp.keySet();
        ArrayList<List> data = new ArrayList<List>();
        for (Object key : keys) {
            Object found = mapInp.get(key);
            if (!(found instanceof List) || ((List)found).isEmpty() || !ToolMap.justContainMapInList((List)found)) continue;
            data.add((List)found);
        }
        return data;
    }

    private static boolean justContainMapInList(List data) {
        for (Object object : data) {
            if (object instanceof Map) continue;
            return false;
        }
        return true;
    }

    public static List<Map<String, Object>> merge(List<Map<String, Object>> aux1, List<Map<String, Object>> aux2, String key) {
        return ToolMap.merge(aux1, aux2, new String[]{key});
    }

    public static List<Map<String, Object>> merge(List<Map<String, Object>> aux1, List<Map<String, Object>> aux2, String[] keys) {
        LinkedList<Map<String, Object>> data1 = new LinkedList<Map<String, Object>>(aux1);
        LinkedList<Map<String, Object>> data2 = new LinkedList<Map<String, Object>>(aux2);
        LinkedList<Map<String, Object>> ret = new LinkedList<Map<String, Object>>();
        if (aux1.isEmpty()) {
            ret.addAll(aux2);
            return ret;
        }
        for (Map map : data1) {
            Optional<Map> found = data2.stream().filter(i -> ToolMap.isEquals(map, i, keys)).findFirst();
            if (found.isPresent()) {
                map.putAll(found.get());
                boolean rem = data2.remove(found.get());
                if (!rem) {
                    throw new ExceptionErroProgramacao("Nao foi possivel remover objeto da lista.");
                }
            }
            ret.add(map);
        }
        ret.addAll(data2);
        return ret;
    }

    public static int orderLong(HashMap h1, HashMap h2, String key) {
        Long v1 = (Long)h1.get(key);
        Long v2 = (Long)h2.get(key);
        return v1.compareTo(v2);
    }

    public static int orderStr(HashMap h1, HashMap h2, String key) {
        String v1 = (String)h1.get(key);
        String v2 = (String)h2.get(key);
        return v1.toUpperCase().compareTo(v2.toUpperCase());
    }

    public static int orderInteger(HashMap h1, HashMap h2, String key) {
        Integer v1 = (Integer)h1.get(key);
        Integer v2 = (Integer)h2.get(key);
        return v1.compareTo(v2);
    }

    public static HashMap<Object, Number> sumIt(HashMap<Object, Number> map, Object key, Number toSum) {
        Class<?> clazz;
        if (map == null || toSum == null) {
            return map;
        }
        Number value = null;
        if (map.containsKey(key) && map.get(key) != null) {
            clazz = map.get(key).getClass();
            value = map.get(key);
        } else {
            clazz = toSum.getClass();
        }
        if (Short.class.isAssignableFrom(clazz)) {
            if (value == null) {
                value = (short)0;
            }
            map.put(key, value.shortValue() + toSum.shortValue());
            return map;
        }
        if (Short.class.isAssignableFrom(clazz)) {
            if (value == null) {
                value = 0;
            }
            map.put(key, value.intValue() + toSum.intValue());
            return map;
        }
        if (Short.class.isAssignableFrom(clazz)) {
            if (value == null) {
                value = 0;
            }
            map.put(key, value.longValue() + toSum.longValue());
            return map;
        }
        if (value == null) {
            value = 0.0;
        }
        map.put(key, value.doubleValue() + toSum.doubleValue());
        return map;
    }
}

