/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.textfile.writter;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.textfile.writter.model.TextLineRegWritter;
import com.touchcomp.basementortools.tools.textfile.writter.model.TextLineWritter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ToolTextFileWritter {
    private List<TextLineWritter> lines;
    private String registerSeparator = "|";
    private boolean decimalSeparator;
    private int decimalSize;
    private Map<String, Boolean> conf = new HashMap<String, Boolean>();
    private static final String CONF_DECIMAL_SIZE = "conf.decimal.size";
    private static final String CONF_DECIMAL_SEPARATOR = "conf.decimal.separator";

    public ToolTextFileWritter() {
        this.lines = new LinkedList<TextLineWritter>();
    }

    public TextLineWritter newLine() {
        TextLineWritter t = new TextLineWritter();
        this.getLines().add(t);
        return t;
    }

    public void add(TextLineWritter text) {
        this.getLines().add(text);
    }

    public ByteArrayOutputStream writeOnByteOut() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeLines(this.writeOnStringBuilder());
        return bout;
    }

    public StringBuilder writeOnStringBuilder() {
        StringBuilder bout = new StringBuilder();
        this.writeLines(bout);
        return bout;
    }

    public String writeOnString() {
        return this.writeOnStringBuilder().toString();
    }

    private void writeLines(StringBuilder sb) {
        for (TextLineWritter line : this.getLines()) {
            this.writeLine(line, sb);
        }
    }

    private void writeLine(TextLineWritter line, StringBuilder sb) {
        for (TextLineRegWritter register : line.getRegisters()) {
            this.writeRegister(register, sb);
            sb.append(this.getRegisterSeparator());
        }
        sb.append("\r\n");
    }

    private void writeRegister(TextLineRegWritter register, StringBuilder sb) {
        switch (register.getTYPE()) {
            case DATA: {
                sb.append(ToolDate.dateToStr(register.getAsDate(), register.getMask()));
                break;
            }
            case TEXTO: {
                String text = register.getAsText();
                if (register.getSize() > 0) {
                    text = ToolString.completaEspacos(text, register.getSize());
                }
                if (register.getMaxSize() > 0 && text != null && text.length() > register.getMaxSize()) {
                    text = text.substring(0, register.getMaxSize());
                }
                sb.append(text);
                break;
            }
            case NUMERO_INTEIRO: {
                String intNumber = register.getAsText();
                if (register.getSize() > 0) {
                    intNumber = ToolFormatter.completaZerosEsquerda(intNumber, register.getSize());
                }
                sb.append(intNumber);
                break;
            }
            case NUMERO_DECIMAL: {
                int decSize = register.getDecimalSize();
                if (this.use(CONF_DECIMAL_SIZE)) {
                    decSize = this.decimalSize;
                }
                boolean decSep = register.isDecimalSeparator();
                if (this.use(CONF_DECIMAL_SEPARATOR)) {
                    decSep = this.decimalSeparator;
                }
                String decNumber = ToolFormatter.formataNumero(register.getAsDecNumber(), decSize);
                if (register.getSize() > 0) {
                    decNumber = ToolFormatter.completaZerosEsquerda(decNumber, register.getSize());
                }
                if (!decSep) {
                    decNumber = ToolString.onlyNumbers(decNumber);
                }
                sb.append(decNumber);
            }
        }
    }

    private boolean use(String key) {
        Boolean aux = this.conf.get(key);
        if (aux == null) {
            aux = false;
        }
        return aux;
    }

    public List<TextLineWritter> getLines() {
        return this.lines;
    }

    public void setLines(List<TextLineWritter> lines) {
        this.lines = lines;
    }

    public String getRegisterSeparator() {
        return this.registerSeparator;
    }

    public void setRegisterSeparator(String registerSeparator) {
        this.registerSeparator = registerSeparator;
    }

    public void setDecimalSeparator(boolean decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
        this.conf.put("decimalSeparator", decimalSeparator);
    }

    public boolean isDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void writeOnOutputStream(File caminhoArquivo) throws ExceptionIO {
        try {
            caminhoArquivo.getParentFile().mkdirs();
            FileOutputStream fout = new FileOutputStream(caminhoArquivo);
            fout.write(this.writeOnString().getBytes());
        }
        catch (IOException ex) {
            Logger.getLogger(ToolTextFileWritter.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{caminhoArquivo});
        }
    }
}

