/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.webserviceclient;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.net.MediaType;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.EnumExcepWebService;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.model.net.ProxyNet;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.web.ToolWebResponse;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public abstract class ToolRESTWebServiceClient2 {
    private static int HTTP_OK = 200;
    private static int HTTP_ACCEPTED = 202;

    public static String downloadStrFrom(String url) throws ExceptionBase {
        return ToolRESTWebServiceClient2.downloadStrFrom(new Config().setUrl(url));
    }

    public static <T> T downloadEntityFrom(Config config, Class<T> ret) throws ExceptionBase {
        String data = ToolRESTWebServiceClient2.downloadStrFrom(config);
        return ToolJson.readJson(data, new TypeReference<T>(){});
    }

    public static <T> T downloadEntityFrom(Config config, TypeReference<T> ret) throws ExceptionBase {
        String data = ToolRESTWebServiceClient2.downloadStrFrom(config);
        if (TMethods.isStrWithData(data)) {
            return ToolJson.readJson(new JSONObject(data).toString(), ret);
        }
        return null;
    }

    public static String downloadStrFrom(Config config) throws ExceptionBase {
        byte[] data = ToolRESTWebServiceClient2.downloadFrom(config);
        if (data == null) {
            return null;
        }
        switch (config.decodeStrType.ordinal()) {
            case 1: {
                return String.valueOf(ToolBase64.decodeBase64(data));
            }
            case 2: {
                return ToolHexString.decodeToStr(new String(data));
            }
        }
        return new String(data);
    }

    public static byte[] downloadFrom(String url) throws ExceptionWebService, ExceptionIO {
        return ToolRESTWebServiceClient2.downloadFrom(new Config().setUrl(url));
    }

    public static byte[] downloadFrom(Config config) throws ExceptionWebService, ExceptionIO {
        int statusCode = 0;
        try {
            HTTPStatusCodes status;
            if (config.getMethod() == null) {
                config.setMethod(Method.GET);
            }
            HttpURLConnection conn = (HttpURLConnection)new URL(config.getUrl()).openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod(config.getMethod().getMethod());
            Set<String> keys = config.getRequestProperties().keySet();
            for (String key : keys) {
                conn.setRequestProperty(key, config.getRequestProperties().get(key));
            }
            if (config.getTimeout() > 0) {
                int multi = 1;
                if (config.getUnit().equals((Object)TimeUnit.SECONDS)) {
                    multi = 1000;
                }
                if (config.getUnit().equals((Object)TimeUnit.MINUTES)) {
                    multi = 60000;
                }
                if (config.getUnit().equals((Object)TimeUnit.HOURS)) {
                    multi = 3600000;
                }
                if (config.getUnit().equals((Object)TimeUnit.DAYS)) {
                    multi = 86400000;
                }
                conn.setReadTimeout(config.getTimeout() * multi);
                conn.setConnectTimeout(config.getTimeout() * multi);
            }
            if (TMethods.isStrWithData(config.getBody())) {
                OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
                out.write(config.getBody());
                out.close();
            }
            if ((status = config.valueOf(statusCode = conn.getResponseCode())) != null) {
                if (status.getThrowable().booleanValue()) {
                    throw new ExceptionWebService(statusCode, conn.getResponseCode() + ": " + status.getDescription() + " \n Msg: " + conn.getResponseMessage() + " \n URL: " + config.getUrl());
                }
            } else if (statusCode != HTTP_OK && statusCode != HTTP_ACCEPTED) {
                ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse(conn.getResponseCode());
                throw new ExceptionWebService(statusCode, EnumExcepWebService.ERRO_CHAMAR_WEBSERVICE, new Object[]{conn.getResponseCode() + ": " + stat.getMesssage() + " \n Msg: " + conn.getResponseMessage() + " \n URL: " + config.getUrl()});
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedInputStream in = statusCode != HTTP_OK && statusCode != HTTP_ACCEPTED ? new BufferedInputStream(conn.getErrorStream()) : new BufferedInputStream(conn.getInputStream());
            byte[] buf = new byte[1024];
            int n = 0;
            while (-1 != (n = ((InputStream)in).read(buf))) {
                out.write(buf, 0, n);
            }
            out.close();
            ((InputStream)in).close();
            byte[] response = out.toByteArray();
            conn.disconnect();
            return response;
        }
        catch (MalformedURLException e) {
            TLogger.get(ToolRESTWebServiceClient2.class).error((Throwable)e);
            throw new ExceptionWebService(statusCode, (IOException)e, new Object[]{config.getUrl()});
        }
        catch (IOException e) {
            TLogger.get(ToolRESTWebServiceClient2.class).error((Throwable)e);
            throw new ExceptionWebService(statusCode, e, new Object[]{e.getMessage(), config.getUrl()});
        }
    }

    public static class Config {
        private String url;
        private int timeout = -1;
        private TimeUnit unit = TimeUnit.SECONDS;
        private Method method;
        private String body;
        private ProxyNet proxyNet;
        private Map<String, String> requestProperties;
        private DecodeStr decodeStrType = DecodeStr.NO_DECODE;
        private List<HTTPStatusCodes> statusCode;

        public Config() {
            this.requestProperties = new HashMap<String, String>();
            this.requestProperties.put("Accept", MediaType.ANY_TYPE.type());
            this.requestProperties.put("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.3) Gecko/20100401");
        }

        public Config(MediaType mediaType) {
            this();
            this.requestProperties.put("Accept", mediaType.type());
        }

        public Config putRequestProp(String prop, String value) {
            this.getRequestProperties().put(prop, value);
            return this;
        }

        public String getUrl() {
            return this.url;
        }

        public Config setUrl(String url) {
            this.url = url;
            return this;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public Config setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public TimeUnit getUnit() {
            return this.unit;
        }

        public Config setUnit(TimeUnit unit) {
            this.unit = unit;
            return this;
        }

        public Method getMethod() {
            return this.method;
        }

        public Config setMethod(Method method) {
            this.method = method;
            return this;
        }

        public ProxyNet getProxyNet() {
            return this.proxyNet;
        }

        public Config setProxyNet(ProxyNet proxyNet) {
            this.proxyNet = proxyNet;
            return this;
        }

        public Map<String, String> getRequestProperties() {
            return this.requestProperties;
        }

        public Config setRequestProperties(Map<String, String> requestProperties) {
            this.requestProperties = requestProperties;
            return this;
        }

        public DecodeStr getDecodeStrType() {
            return this.decodeStrType;
        }

        public Config setDecodeStrType(DecodeStr decodeStrType) {
            this.decodeStrType = decodeStrType;
            return this;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public List<HTTPStatusCodes> getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(List<HTTPStatusCodes> statusCode) {
            this.statusCode = statusCode;
        }

        public HTTPStatusCodes valueOf(Integer statusCode) {
            List<HTTPStatusCodes> status = this.getStatusCode();
            if (status != null && statusCode != null && statusCode > 0) {
                HTTPStatusCodes httpStatus = status.stream().filter(s -> Objects.equals(statusCode, s.getCode())).findAny().orElse(null);
                return httpStatus;
            }
            return null;
        }
    }

    public static enum DecodeStr {
        NO_DECODE,
        BASE_64,
        HEX;

    }

    public static enum Method {
        GET("GET"),
        POST("POST"),
        PUT("PUT"),
        DELETE("DELETE");

        private final String method;

        private Method(String method) {
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }

    public static class HTTPStatusCodes {
        private Integer code;
        private String status;
        private String description;
        private Boolean throwable;

        public Integer getCode() {
            return this.code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Boolean getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Boolean throwable) {
            this.throwable = throwable;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}

