/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.analiseprvendaprod;

import com.touchcomp.basementor.model.vo.AnalisePrVendaProd;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCen;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidAnalisePrVendaProd
extends ValidGenericEntitiesImpl<AnalisePrVendaProd> {
    @Override
    protected void isValid(AnalisePrVendaProd vo) {
        this.validNotEmpty(this.code("V.ERP.2015.001", "cenarios"), vo.getCenarios());
        if (TMethods.isNotNull((Object)vo.getTabelaPrecoBaseProduto()).booleanValue()) {
            this.validNotEquals(this.code("V.ERP.2015.002", "produto"), vo.getTabelaPrecoBaseProduto().getProduto(), vo.getProduto());
        }
        if (TMethods.isWithData((Collection)vo.getCenarios())) {
            Boolean cenarioEscolhido = false;
            for (AnalisePrVendaProdCen cen : vo.getCenarios()) {
                this.valid(this.code("V.ERP.2015.003", "cenarios.descricao"), cen.getDescricao());
                this.valid(this.code("V.ERP.2015.004", "cenarios.avaliadorExpressoes"), cen.getAvaliadorExpressoes());
                if (!TMethods.isAffirmative((Number)cen.getCenarioEscolhido())) continue;
                cenarioEscolhido = true;
            }
            if (!Boolean.TRUE.equals(cenarioEscolhido)) {
                this.addError(this.code("V.ERP.2015.005", "cenarios.escolhido"), vo.getCenarios());
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "2015 - An\u00e1lise de Custo";
    }
}

