/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.apuracaoreinf;

import com.touchcomp.basementor.model.vo.ApuracaoReinf;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemReinf2010;
import com.touchcomp.basementor.model.vo.ItemReinf2020;
import com.touchcomp.basementor.model.vo.ItemReinf4010;
import com.touchcomp.basementor.model.vo.ItemReinf4020;
import com.touchcomp.basementor.model.vo.ItemReinf4020NaoIdentificado;
import com.touchcomp.basementor.model.vo.ItemReinfNotas2010;
import com.touchcomp.basementor.model.vo.ItemReinfNotas2020;
import com.touchcomp.basementor.model.vo.ItemReinfNotas4010;
import com.touchcomp.basementor.model.vo.ItemReinfNotas4020;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidApuracaoReinf
extends ValidGenericEntitiesImpl<ApuracaoReinf> {
    @Override
    protected void isValid(ApuracaoReinf vo) {
        this.valid(this.code("V.ERP.1696.001", "periodo"), vo.getPeriodo());
        this.validarItensReinf2010(vo);
        this.validarItensReinf2020(vo);
        this.validarItensReinf4010(vo);
        this.validarItensReinf4020(vo);
        this.validarItensReinf4020NI(vo);
    }

    private void validarItensReinf2010(ApuracaoReinf vo) {
        if (TMethods.isWithData((Collection)vo.getItens2010())) {
            for (ItemReinf2010 i : vo.getItens2010()) {
                for (ItemReinfNotas2010 n : i.getItens()) {
                    this.valid(this.code("V.ERP.1696.002", "notaTerceiros"), n.getNotaTerceiros());
                    if (!TMethods.isNotNull((Object)n.getNotaTerceiros()).booleanValue()) continue;
                    NotaFiscalTerceiros nota = n.getNotaTerceiros();
                    this.valid(this.code("V.ERP.1696.003", "serie", nota.getNumeroNota(), i.getPessoa().getNome()), nota.getSerie());
                    for (ItemNotaTerceiros itemTerc : nota.getItemNotaTerceiros()) {
                        Double valorTotalRetencoes = itemTerc.getItemNotaLivroFiscal().getVrInss();
                        if (!(valorTotalRetencoes > 0.0) || !TMethods.isNull((Object)itemTerc.getTipoServico()).booleanValue()) continue;
                        this.addError(this.code("V.ERP.1696.004", "serie", nota.getNumeroNota(), i.getPessoa().getNome()), itemTerc);
                    }
                }
            }
        }
    }

    private void validarItensReinf2020(ApuracaoReinf vo) {
        if (TMethods.isWithData((Collection)vo.getItens2020())) {
            for (ItemReinf2020 i : vo.getItens2020()) {
                for (ItemReinfNotas2020 n : i.getItens()) {
                    if (TMethods.isNotNull((Object)n.getNotaPropria()).booleanValue()) {
                        this.valid(this.code("V.ERP.1696.005", "serie", n.getNotaPropria().getNumeroNota(), i.getPessoa().getNome()), n.getNotaPropria().getSerie());
                        for (ItemNotaFiscalPropria itemProp : n.getNotaPropria().getItensNotaPropria()) {
                            Double valorTotalRetencoes = itemProp.getItemNotaLivroFiscal().getVrInss();
                            if (!(valorTotalRetencoes > 0.0) || !TMethods.isNull((Object)itemProp.getTipoServicoReinf()).booleanValue()) continue;
                            this.addError(this.code("V.ERP.1696.006", "tipoServicoReinf", n.getNotaPropria().getNumeroNota(), i.getPessoa().getNome()), itemProp.getTipoServicoReinf());
                        }
                    }
                    if (!TMethods.isNotNull((Object)n.getRps()).booleanValue()) continue;
                    Double valorTotalRetencoes = n.getRps().getValorInss();
                    if (valorTotalRetencoes > 0.0 && TMethods.isNull((Object)n.getRps().getTipoServico()).booleanValue()) {
                        this.addError(this.code("V.ERP.1696.007", "tipoServico", n.getRps().getNumero(), i.getPessoa().getNome()), n.getRps().getTipoServico());
                    }
                    this.valid(this.code("V.ERP.1696.008", "serie", n.getRps().getNumero(), i.getPessoa().getNome()), n.getRps().getSerie());
                }
            }
        }
    }

    private void validarItensReinf4010(ApuracaoReinf vo) {
        if (TMethods.isWithData((Collection)vo.getItensReinf4010())) {
            for (ItemReinf4010 i : vo.getItensReinf4010()) {
                for (ItemReinfNotas4010 n : i.getItensNotas()) {
                    NotaFiscalTerceiros nota = n.getNotaTerceiros();
                    for (ItemNotaTerceiros itemTerc : nota.getItemNotaTerceiros()) {
                        if (!(itemTerc.getItemNotaLivroFiscal().getVrIrrf() > 0.0) || !TMethods.isNull((Object)itemTerc.getNaturezaRendimento()).booleanValue()) continue;
                        this.addError(this.code("V.ERP.1696.009", "naturezaRendimento", n.getNotaTerceiros().getNumeroNota(), i.getPessoa().getNome()), itemTerc.getNaturezaRendimento());
                    }
                }
            }
        }
    }

    private void validarItensReinf4020(ApuracaoReinf vo) {
        if (TMethods.isWithData((Collection)vo.getItensReinf4020())) {
            for (ItemReinf4020 i : vo.getItensReinf4020()) {
                for (ItemReinfNotas4020 n : i.getItensNotas()) {
                    this.valid(this.code("V.ERP.1696.010", "naturezaRendimento", n.getNotaTerceiros().getNumeroNota(), i.getPessoa().getNome()), n.getNaturezaRendimento());
                }
            }
        }
    }

    private void validarItensReinf4020NI(ApuracaoReinf vo) {
        if (TMethods.isWithData((Collection)vo.getItensReinf4020())) {
            for (ItemReinf4020NaoIdentificado item : vo.getItensReinf4020NI()) {
                this.valid(this.code("V.ERP.1696.011", "naturezaRendimento", item.getCpf()), item.getNaturezaRendimento());
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "1696 - Apura\u00e7\u00e3o Reinf";
    }
}

