/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.bem;

import com.touchcomp.basementor.model.vo.Bem;
import com.touchcomp.basementor.model.vo.BemComponenteCompra;
import com.touchcomp.basementor.model.vo.BemSpedPisCofins;
import com.touchcomp.basementor.model.vo.BemTipoDepreciacao;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidBem
extends ValidGenericEntitiesImpl<Bem> {
    @Override
    protected void isValid(Bem vo) {
        this.valid(this.code("V.ERP.0411.001", "descricao"), vo.getDescricao());
        this.valid(this.code("V.ERP.0411.002", "dataCompra"), vo.getDataCompra());
        this.validGreather0(this.code("V.ERP.0411.003", "valorCompra"), vo.getValorCompra());
        this.valid(this.code("V.ERP.0411.004", "centroCusto"), vo.getCentroCusto());
        this.valid(this.code("V.ERP.0411.033", "empresa"), vo.getEmpresa());
        if (this.valid(this.code("V.ERP.0411.006", "tipoBem"), vo.getTipoBem()) && this.isAffirmative(vo.getTipoBem().getDepreciar())) {
            this.validGreather0(this.code("V.ERP.0411.007", "nrParcelaIcmsInicial"), vo.getNrParcelaIcmsInicial());
            this.validGreather0(this.code("V.ERP.0411.008", "nrParcelasIcms"), vo.getNrParcelasIcms());
            this.validMax(this.code("V.ERP.0411.009", "nrParcelasIcms"), vo.getNrParcelaIcmsInicial(), vo.getNrParcelasIcms());
            if (this.validNotEmpty(this.code("V.ERP.0411.010", "bensTipoDepreciacao"), vo.getBensTipoDepreciacao())) {
                this.validarBensTipoDep(vo.getBensTipoDepreciacao(), vo);
            }
        }
        if (this.valid(this.code("V.ERP.0411.011", "bemUsadoPisCofins"), vo.getBemUsadoPisCofins()) && this.isAffirmative(vo.getBemUsadoPisCofins())) {
            this.validar(vo.getBemSpedPisCofins());
        }
        if (this.valid(this.code("V.ERP.0411.012", "componentesProduto"), (Object)vo.getComponentesProduto())) {
            this.validarComponentes(vo.getComponentesProduto());
        }
    }

    @Override
    public String getSimpleName() {
        return "0411";
    }

    private void validar(BemSpedPisCofins vo) {
        this.valid(this.code("V.ERP.0411.013", "naturezaBCCredito"), vo.getNaturezaBCCredito());
        this.valid(this.code("V.ERP.0411.014", "idenBemImobilizado"), vo.getIdenBemImobilizado());
        this.valid(this.code("V.ERP.0411.015", "indOrigCredBemPisCofins"), vo.getIndOrigCredBemPisCofins());
        this.valid(this.code("V.ERP.0411.016", "indUtilBemImobilizado"), vo.getIndUtilBemImobilizado());
        this.valid(this.code("V.ERP.0411.017", "cstPis"), vo.getCstPis());
        this.valid(this.code("V.ERP.0411.018", "cstCofins"), vo.getCstCofins());
        if (this.valid(this.code("V.ERP.0411.013", "naturezaBCCredito"), vo.getNaturezaBCCredito()) && this.isEquals(vo.getNaturezaBCCredito().getCodigo(), "10")) {
            this.valid(this.code("V.ERP.0411.020", "parcOperNaoBcCred"), vo.getParcOperNaoBcCred());
            this.valid(this.code("V.ERP.0411.021", "vrBcCred"), vo.getVrBcCred());
            this.valid(this.code("V.ERP.0411.022", "indNrParcela"), vo.getIndNrParcela());
            this.validGreather0(this.code("V.ERP.0411.023", "nrParcela"), vo.getNrParcela());
            this.validGreather0(this.code("V.ERP.0411.024", "nrParcelaInicial"), vo.getNrParcelaInicial());
        }
        this.valid(this.code("V.ERP.0411.025", "aliquotaPis"), vo.getAliquotaPis());
        this.valid(this.code("V.ERP.0411.026", "aliquotaCofins"), vo.getAliquotaCofins());
        this.valid(this.code("V.ERP.0411.027", "planoConta"), vo.getPlanoConta());
    }

    private void validarComponentes(List<BemComponenteCompra> componentesProduto) {
        for (BemComponenteCompra vo : componentesProduto) {
            this.valid(this.code("V.ERP.0411.028", "dataCompra"), vo.getDataCompra());
            this.valid(this.code("V.ERP.0411.029", "valor"), vo.getValor());
        }
    }

    private void validarBensTipoDep(List<BemTipoDepreciacao> bensTipoDepreciacao, Bem bem) {
        for (BemTipoDepreciacao vo : bensTipoDepreciacao) {
            this.valid(this.code("V.ERP.0411.030", "dataInicial"), vo.getDataInicial());
            this.valid(this.code("V.ERP.0411.031", "tipoDepreciacao"), vo.getTipoDepreciacao());
            this.validBefore(this.code("V.ERP.0411.032", "dataCompra"), bem.getDataCompra(), vo.getDataInicial(), new Object[0]);
        }
    }
}

