/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.cadastroenderecowms;

import com.touchcomp.basementor.model.vo.WmsEndereco;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidWmsEndereco
extends ValidGenericEntitiesImpl<WmsEndereco> {
    private Boolean valid = true;
    private Object objetoInvalido;
    private Integer tamMascara = 0;
    private boolean haMascaraMaior = false;

    @Override
    protected void isValid(WmsEndereco entity) {
        if (this.valid(this.code("V.ERP.1905.003", "codigo"), entity.getCodigo())) {
            this.tamMascara = entity.getCodigo().length();
        }
        if (!this.validarCodigo(entity)) {
            this.addError(this.code("V.ERP.1905.001", "codigo"), this.objetoInvalido);
        }
        if (!this.validarDescricao(entity)) {
            this.addError(this.code("V.ERP.1905.002", "descricao"), this.objetoInvalido);
        }
        this.haCodigoMaiorQueMascara(entity.getChildren());
        if (this.haMascaraMaior) {
            this.addError(this.code("V.ERP.1905.003", "codigo"), this.objetoInvalido);
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private boolean validarDescricao(WmsEndereco wmsEndereco) {
        this.valid = true;
        if (ToolMethods.isNull((Object)wmsEndereco.getDescricao()).booleanValue() || wmsEndereco.getDescricao().trim().isEmpty()) {
            this.valid = false;
            this.objetoInvalido = wmsEndereco.getDescricao();
        }
        if (wmsEndereco.getChildren() != null) {
            for (WmsEndereco filhoAtual : wmsEndereco.getChildren()) {
                if (!this.valid.booleanValue()) break;
                this.validarDescricao(filhoAtual);
            }
        }
        return this.valid;
    }

    private boolean validarCodigo(WmsEndereco wmsEndereco) {
        this.valid = true;
        if (ToolMethods.isNull((Object)wmsEndereco.getCodigo()).booleanValue() || wmsEndereco.getCodigo().trim().isEmpty()) {
            this.valid = false;
            this.objetoInvalido = wmsEndereco.getCodigo();
        }
        if (wmsEndereco.getChildren() != null) {
            for (WmsEndereco filhoAtual : wmsEndereco.getChildren()) {
                if (!this.valid.booleanValue()) break;
                this.validarCodigo(filhoAtual);
            }
        }
        return this.valid;
    }

    private boolean haCodigoMaiorQueMascara(List<WmsEndereco> wmsEndereco) {
        if (wmsEndereco == null) {
            return false;
        }
        for (WmsEndereco current : wmsEndereco) {
            if (current.getCodigo() != null && current.getCodigo().length() > this.tamMascara) {
                this.haMascaraMaior = true;
                return true;
            }
            this.haCodigoMaiorQueMascara(current.getChildren());
        }
        return false;
    }
}

