/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.categoriaproduto;

import com.touchcomp.basementor.model.vo.CategoriaProduto;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidCategoriaProduto
extends ValidGenericEntitiesImpl<CategoriaProduto> {
    @Override
    protected void isValid(CategoriaProduto vo) {
        this.valid(this.code("V.ERP.1869.001", "codigo"), vo.getCodigo());
        this.valid(this.code("V.ERP.1869.002", "descricao"), vo.getDescricao());
        this.valid(this.code("V.ERP.1869.006", "ativo"), vo.getAtivo());
        this.validCodigo(vo);
    }

    protected boolean possuiApenasNumeros(String cod) {
        return ToolMethods.isNull((Object)cod) != false || cod.matches("\\d+");
    }

    protected boolean isMultiploDeDois(String cod) {
        return ToolMethods.isNull((Object)cod) != false || cod.length() % 2 == 0;
    }

    protected boolean codPaiNuloDifDoisDigitos(CategoriaProduto pai, String cod) {
        return ToolMethods.isNull((Object)pai) != false || cod.length() - pai.getCodigo().length() == 2;
    }

    protected boolean startsWithPaiCod(CategoriaProduto pai, String cod) {
        return ToolMethods.isNull((Object)pai) != false || cod.startsWith(pai.getCodigo());
    }

    private void validCodigo(CategoriaProduto vo) {
        String codigo = vo.getCodigo();
        CategoriaProduto pai = vo.getCategoriaPai();
        if (!this.isMultiploDeDois(codigo)) {
            this.addError(this.code("V.ERP.1869.003", "codigo"), codigo);
        }
        if (!this.codPaiNuloDifDoisDigitos(pai, codigo)) {
            this.addError(this.code("V.ERP.1869.004", "codigo"), codigo);
        }
        if (!this.possuiApenasNumeros(codigo)) {
            this.addError(this.code("V.ERP.1869.005", "codigo"), codigo);
        }
        if (!this.startsWithPaiCod(pai, codigo)) {
            this.addError(this.code("V.ERP.1869.007", "codigo"), codigo);
        }
    }

    @Override
    public String getSimpleName() {
        return "1869";
    }
}

