/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.checklist;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CheckList;
import com.touchcomp.basementor.model.vo.CheckListItem;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidCheckList
extends ValidGenericEntitiesImpl<CheckList> {
    @Override
    protected void isValid(CheckList vo) {
        this.valid(this.code("V.ERP.1562.001", "modeloCheckList"), vo.getDataHoraCheckList());
        this.valid(this.code("V.ERP.1562.002", "modeloCheckList"), vo.getModeloCheckList());
        this.valid(this.code("V.ERP.1562.003", "origemCheckList"), vo.getOrigemCheckList());
        this.validNotEmpty(this.code("V.ERP.1562.004"), vo.getItensCheckList());
        this.validItensChecklist(vo);
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validItensChecklist(CheckList vo) {
        if (ToolMethods.isWithData((Collection)vo.getItensCheckList())) {
            for (CheckListItem item : vo.getItensCheckList()) {
                this.valid(this.code("V.ERP.1562.005"), item.getModeloCheckListItOpcao());
                if (!ToolMethods.isNotNull((Object)item.getModeloCheckListItOpcao()).booleanValue()) continue;
                if (this.isEquals(item.getModeloCheckListItOpcao().getOpcaoCheckList().getObrigarObservacao(), EnumConstantsMentorSimNao.SIM.getValue())) {
                    this.valid(this.code("V.ERP.1562.006", "itensCheckList.observacao", item.getModeloCheckListItem().getDescricao()), item.getObservacao());
                }
                if (!this.isEquals(item.getModeloCheckListItOpcao().getOpcaoCheckList().getObrigarFoto(), EnumConstantsMentorSimNao.SIM.getValue())) continue;
                this.validEquals(this.code("V.ERP.1562.007", "itensCheckList.informadoFoto", item.getModeloCheckListItem().getDescricao()), item.getInformadoFoto(), EnumConstantsMentorSimNao.NAO.getValue());
            }
        }
    }
}

