/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.colaborador;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstPensaoColaborador;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoAdiantamento;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocCategoriaTrabalhador;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class ValidColaborador
extends ValidGenericEntitiesImpl<Colaborador> {
    @Override
    protected void isValid(Colaborador vo) {
        EmpresaRh empresaRh;
        this.validEquals(this.code("V.ERP.0516.001", "ativo"), vo.getAtivo(), EnumConstantsMentorSimNao.NAO.getEnumId());
        this.validPessoa(vo.getPessoa());
        this.valid(this.code("V.ERP.0516.005", "numeroRegistro"), vo.getNumeroRegistro());
        this.validEquals(this.code("V.ERP.0516.006", "numeroRegistro"), vo.getNumeroRegistro(), 0.0);
        this.valid(this.code("V.ERP.0516.007", "estabelecimento"), vo.getEstabelecimento());
        this.validEsocCategoriaTrabalhador(vo.getEsocCategoriaTrabalhador(), vo);
        this.valid(this.code("V.ERP.0516.009", "centroCusto"), vo.getCentroCusto());
        this.valid(this.code("V.ERP.0516.010", "tipoColaborador"), vo.getTipoColaborador());
        this.valid(this.code("V.ERP.0516.011", "racaCor"), vo.getRacaCor());
        this.valid(this.code("V.ERP.0516.012", "departamento"), vo.getDepartamento());
        this.valid(this.code("V.ERP.0516.013", "cidadeNascimento"), vo.getCidadeNascimento());
        this.valid(this.code("V.ERP.0516.014", "alvaraJudicial"), vo.getAlvaraJudicial());
        this.valid(this.code("V.ERP.0516.015", "sexo"), vo.getSexo());
        this.valid(this.code("V.ERP.0516.016", "nacionalidade"), vo.getNacionalidade());
        this.valid(this.code("V.ERP.0516.017", "grauInstrucao"), vo.getGrauInstrucao());
        this.valid(this.code("V.ERP.0516.018", "tipoLogradouroEndereco"), vo.getTipoLogradouroEndereco());
        this.validTipoColaborador(vo.getTipoColaborador(), vo);
        if (this.isEquals(vo.getInformarReciboManual(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.valid(this.code("V.ERP.0516.038", "numeroReciboEsocial"), vo.getNumeroReciboEsocial());
        }
        this.valid(this.code("V.ERP.0516.039", "esocCategoriaTrabalhador"), vo.getEsocCategoriaTrabalhador());
        this.valid(this.code("V.ERP.0516.040", "lotacaoTributaria"), vo.getLotacaoTributaria());
        this.valid(this.code("V.ERP.0516.041", "estadoCivil"), vo.getEstadoCivil());
        this.valid(this.code("V.ERP.0516.042", "dataAdmissao"), vo.getDataAdmissao());
        this.valid(this.code("V.ERP.0516.043", "funcao"), vo.getFuncao());
        this.valid(this.code("V.ERP.0516.044", "eventos"), (Object)vo.getEventos());
        this.valid(this.code("V.ERP.0516.045", "tipoSalario"), vo.getTipoSalario());
        if (this.isEquals(vo.getTipoAdiantamento(), EnumConstTipoAdiantamento.ADIANTAMENTO_POR_PERCENTUAL.getEnumId())) {
            this.validMax(this.code("V.ERP.0516.046"), vo.getPercValorAdiantamento(), 100.0);
        }
        this.valid(this.code("V.ERP.0516.047", "naturezaAtividade"), vo.getNaturezaAtividade());
        if (this.isEquals(vo.getPossuiDescontoPensao(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.validEquals(this.code("V.ERP.0516.048", "nrBeneficiarios"), vo.getNrBeneficiarios(), EnumConstantsMentorSimNao.NAO.getValue());
            this.valid(this.code("V.ERP.0516.049", "tipoPagamentoPensao"), vo.getTipoPagamentoPensao());
            if (ToolMethods.isNull((Object)vo.getPercentualPensao()).booleanValue() && this.isEquals(vo.getTipoPagamentoPensao().getCodigo(), EnumConstPensaoColaborador.PENSAO_FIXO.getEnumId()) || vo.getPercentualPensao() <= 0.0 && this.isEquals(vo.getTipoPagamentoPensao().getCodigo(), EnumConstPensaoColaborador.PENSAO_FIXO.getEnumId())) {
                this.addError(this.code("V.ERP.0516.050", "percentualPensao"), vo.getPercentualPensao());
            }
            if (ToolMethods.isNull((Object)(vo.getValorFixoPensao() <= 0.0 ? 1 : 0)).booleanValue() && this.isEquals(vo.getTipoPagamentoPensao().getCodigo(), EnumConstPensaoColaborador.PENSAO_FIXO.getEnumId()) || vo.getValorFixoPensao() <= 0.0 && this.isEquals(vo.getTipoPagamentoPensao().getCodigo(), EnumConstPensaoColaborador.PENSAO_FIXO.getEnumId())) {
                this.addError(this.code("V.ERP.0516.051"), vo.getValorFixoPensao());
            }
        }
        if (ToolMethods.isNotNull((Object)vo.getTipoSalario()).booleanValue() && this.isEquals(vo.getTipoSalario().getCodigoEsocial(), "7")) {
            this.valid(this.code("V.ERP.0516.052", "descricaoSalario"), vo.getDescricaoSalario());
        }
        if (ToolMethods.isNotNull((Object)vo.getTipoAdmissaoEsocial()).booleanValue() && this.isEquals(vo.getTipoAdmissaoEsocial().getCodigo(), "2")) {
            this.valid(this.code("V.ERP.0516.053", "matriculaAnterior"), vo.getMatriculaAnterior());
            this.valid(this.code("V.ERP.0516.054", "dataTransferenciaEmpregado"), vo.getDataTransferenciaEmpregado());
            this.valid(this.code("V.ERP.0516.055", "cnpjEmpregadorAnterior"), vo.getCnpjEmpregadorAnterior());
        }
        if (ToolMethods.isNotNull((Object)vo.getEmpresa()).booleanValue() && ToolMethods.isNotNull((Object)this.getSharedObjects()).booleanValue() && ToolMethods.isNotNull((Object)(empresaRh = this.getSharedObjects().getEmpresaRh(vo.getEmpresa()))).booleanValue() && ToolMethods.isNotNull((Object)empresaRh.getVariacaoPagamentoFolha()).booleanValue() && this.isEquals(empresaRh.getVariacaoPagamentoFolha(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.valid(this.code("V.ERP.0516.056", "tipoPagamentoFolha"), vo.getTipoPagamentoFolha());
        }
    }

    private void validPessoa(Pessoa pessoa) {
        this.valid(this.code("V.ERP.0516.002", "pessoa", "pessoa"), pessoa);
        if (ToolMethods.isNotNull((Object)pessoa).booleanValue()) {
            this.validComplemento(pessoa.getComplemento());
        }
    }

    private void validComplemento(Complemento complemento) {
        if (ToolMethods.isNotNull((Object)complemento).booleanValue()) {
            if (ToolMethods.isNotNull((Object)complemento.getDataNascimento()).booleanValue()) {
                this.validOlderAge(complemento.getDataNascimento());
            }
            this.valid(this.code("V.ERP.0516.004", "cpf"), complemento.getCnpj());
        }
    }

    private void validOlderAge(Date dtNascimento) {
        Integer anoAtual = ToolDate.yearFromDate((Object)new Date());
        Integer anoNascimento = ToolDate.yearFromDate((Object)dtNascimento);
        if (ToolMethods.isNull((Object)dtNascimento).booleanValue() || anoAtual - anoNascimento <= 14) {
            this.addError(this.code("V.ERP.0516.003", "dataNascimento"), dtNascimento);
        }
    }

    private void validEsocCategoriaTrabalhador(EsocCategoriaTrabalhador esocCategoriaTrabalhador, Colaborador vo) {
        if (ToolMethods.isNotNull((Object)esocCategoriaTrabalhador).booleanValue() && this.isEquals(esocCategoriaTrabalhador.getCodigo(), "101")) {
            this.valid(this.code("V.ERP.0516.008", "numeroRegistroESocial"), vo.getNumeroRegistroESocial());
        }
    }

    private void validTipoColaborador(TipoColaborador tipoColaborador, Colaborador vo) {
        if (ToolMethods.isNotNull((Object)tipoColaborador).booleanValue()) {
            if (!(this.isEquals(tipoColaborador.getIdentificador(), EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()) || this.isEquals(tipoColaborador.getIdentificador(), EnumConstTipoColaborador.AUTONOMO_FRETE.getValue()) || this.isEquals(tipoColaborador.getIdentificador(), EnumConstTipoColaborador.ESTAGIARIO.getValue()) || this.isEquals(tipoColaborador.getIdentificador(), EnumConstTipoColaborador.AUTONOMO.getValue()))) {
                this.valid(this.code("V.ERP.0516.019", "carteiraProfissional"), vo.getCarteiraProfissional());
                this.valid(this.code("V.ERP.0516.020", "tipoAdmissaoRais"), vo.getTipoAdmissaoRais());
                this.valid(this.code("V.ERP.0516.021", "horarioTrabalho"), vo.getHorarioTrabalho());
                this.valid(this.code("V.ERP.0516.022", "regimeJornadaTrabalho"), vo.getRegimeJornadaTrabalho());
                this.valid(this.code("V.ERP.0516.025", "tipoAdmissaoCaged"), vo.getTipoAdmissaoCaged());
                this.validGreather0(this.code("V.ERP.0516.026", "diasJornada"), vo.getDiasJornada());
                this.valid(this.code("V.ERP.0516.027", "jornadaSemanal"), vo.getJornadaSemanal());
                this.valid(this.code("V.ERP.0516.028", "horasTrabDia"), vo.getHorasTrabDia());
                this.validEquals(this.code("V.ERP.0516.031", "horaExtraHabitual"), vo.getHoraExtraHabitual(), EnumConstantsMentorSimNao.NAO.getValue());
                this.validEquals(this.code("V.ERP.0516.032", "addNoturnoHabitual"), vo.getAddNoturnoHabitual(), EnumConstantsMentorSimNao.NAO.getValue());
                this.valid(this.code("V.ERP.0516.033", "indicadorVinculoTrabalhador"), vo.getIndicadorVinculoTrabalhador());
            }
            if (!this.isEquals(tipoColaborador.getIdentificador(), EnumConstTipoColaborador.ESTAGIARIO.getValue())) {
                this.valid(this.code("V.ERP.0516.023", "categoriaSefip"), vo.getCategoriaSefip());
                this.valid(this.code("V.ERP.0516.024", "categoriaTrabalhador"), vo.getCategoriaTrabalhador());
                this.valid(this.code("V.ERP.0516.034", "regimePrevidenciario"), vo.getRegimePrevidenciario());
                this.valid(this.code("V.ERP.0516.035", "regimeTrabalhista"), vo.getRegimeTrabalhista());
                this.valid(this.code("V.ERP.0516.036", "classificacaoColaborador"), vo.getClassificacaoColaborador());
                this.valid(this.code("V.ERP.0516.037", "localTrabalhoColaboradorCidade"), vo.getLocalTrabalhoColaboradorCidade());
            }
        }
    }

    public boolean validarNumeroPis(String strPis) {
        if (ToolMethods.isNull((Object)strPis).booleanValue()) {
            return false;
        }
        if (strPis.length() == 0) {
            return false;
        }
        if (strPis.length() < 11) {
            return false;
        }
        int qDig = strPis.length();
        int dig1 = Integer.parseInt(this.Midw(strPis, qDig - 10, 1));
        int dig2 = Integer.parseInt(this.Midw(strPis, qDig - 9, 1));
        int dig3 = Integer.parseInt(this.Midw(strPis, qDig - 8, 1));
        int dig4 = Integer.parseInt(this.Midw(strPis, qDig - 7, 1));
        int dig5 = Integer.parseInt(this.Midw(strPis, qDig - 6, 1));
        int dig6 = Integer.parseInt(this.Midw(strPis, qDig - 5, 1));
        int dig7 = Integer.parseInt(this.Midw(strPis, qDig - 4, 1));
        int dig8 = Integer.parseInt(this.Midw(strPis, qDig - 3, 1));
        int dig9 = Integer.parseInt(this.Midw(strPis, qDig - 2, 1));
        int dig10 = Integer.parseInt(this.Midw(strPis, qDig - 1, 1));
        int dig11 = Integer.parseInt(this.Midw(strPis, qDig, 1));
        Integer soma = dig1 * 3 + dig2 * 2 + dig3 * 9 + dig4 * 8 + dig5 * 7 + dig6 * 6 + dig7 * 5 + dig8 * 4 + dig9 * 3 + dig10 * 2;
        Integer resto = 11 - soma % 11;
        if (resto == 11 || resto == 10 || resto < 0) {
            resto = 0;
        }
        return resto == dig11;
    }

    private String Midw(String texto, int inicio, int tamanho) {
        String strMid = texto.substring(inicio - 1, inicio + (tamanho - 1));
        return strMid;
    }

    @Override
    public String getSimpleName() {
        return "";
    }
}

