/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.comunicadoproducao;

import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemComProdOutrosCustos;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidComunicadoProducaoContabil
extends ValidGenericEntitiesImpl<ComunicadoProducao> {
    @Override
    protected void isValid(ComunicadoProducao entity) {
        this.validarItens(entity);
    }

    @Override
    public String getSimpleName() {
        return "0940";
    }

    private void validarItens(ComunicadoProducao entity) {
        if (entity == null) {
            return;
        }
        for (ItemComunicadoProducao item : entity.getItemComunicadoProducao()) {
            this.validarDocVinculados(item.getItensOutrosCustos());
        }
    }

    private void validarDocVinculados(List<ItemComProdOutrosCustos> itensOutrosCustos) {
        for (ItemComProdOutrosCustos item : itensOutrosCustos) {
            PlanoConta pcCred = null;
            if (item.getGradeItemNFTerceirosOrigem() != null) {
                pcCred = item.getGradeItemNFTerceirosOrigem().getItemNotaTerceiros().getPlanoContaDeb();
            } else if (item.getGradeItemNFPropriaOrigem() != null) {
                pcCred = item.getGradeItemNFPropriaOrigem().getItemNotaFiscalPropria().getPlanoContaDeb();
            } else if (item.getRpsOrigem() != null) {
                pcCred = item.getGradeItemNFTerceirosOrigem().getItemNotaTerceiros().getPlanoContaDeb();
            }
            this.valid(this.code("E.ERP.0940.001"), pcCred);
        }
    }
}

