/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.comunicadoproducao;

import com.touchcomp.basementor.constants.enums.tipoproducao.EnumConstTipoProducao;
import com.touchcomp.basementor.model.vo.FichaTecItemComProducao;
import com.touchcomp.basementor.model.vo.GradeItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemModFichaTecVlrPad;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.ValorFichaTecItemComProducao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.dto.ValidGenericDTOImpl;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.modelofichatecnica.InterfaceFichaTecnica;
import com.touchcomp.basementorvalidator.entities.impl.modelofichatecnica.InterfaceFichaTecnicaValor;
import com.touchcomp.basementorvalidator.entities.impl.modelofichatecnica.ValidFichaTecnica;
import com.touchcomp.basementorvalidator.entities.impl.requisicao.ValidRequisicao;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidItemComunicadoProducao
extends ValidGenericEntitiesImpl<ItemComunicadoProducao> {
    ValidFichaTecnica validFichaTecnica;
    ValidRequisicao validRequisicao;

    public ValidItemComunicadoProducao(ValidFichaTecnica validFichaTecnica, ValidRequisicao validRequisicao) {
        this.validFichaTecnica = validFichaTecnica;
        this.validRequisicao = validRequisicao;
    }

    @Override
    protected void isValid(ItemComunicadoProducao vo) {
        if (this.valid(this.code("V.ERP.0426.005", "tipoProducao"), vo.getTipoProducao()) && EnumConstTipoProducao.get((Short)vo.getTipoProducao().getTipo()).isRefugoSobra()) {
            this.valid(this.code("V.ERP.0426.006", "tiposDefeitos"), vo.getTiposDefeitos());
        }
        this.valid(this.code("V.ERP.0426.010", "centroCusto"), vo.getCentroCusto());
        this.valid(this.code("V.ERP.0426.011", "produto"), vo.getProduto());
        this.valid(this.code("V.ERP.0426.009", "centroEstoque"), vo.getCentroEstoque());
        this.valid(this.code("V.ERP.0426.007", "quantidadeTotal"), vo.getQuantidadeTotal());
        this.valid(this.code("V.ERP.0426.008", "quantidadeTotalRef"), vo.getQuantidadeTotalRef());
        if (this.valid(this.code("V.ERP.0426.016", "itemComunicadoProducao"), (Object)vo.getGradeItemComunicadoProducao())) {
            this.validarGrades(vo);
        }
        if (ToolMethods.isWithData((Collection)vo.getRequisicoes())) {
            this.valid((ValidGenericEntitiesImpl)this.validRequisicao, vo.getRequisicoes());
        }
        this.validFichasTecnicas(vo);
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validarGrades(ItemComunicadoProducao item) {
        for (GradeItemComunicadoProducao vo : item.getGradeItemComunicadoProducao()) {
            this.validGreather0(this.code("V.ERP.0426.012", "quantidade"), vo.getQuantidade());
            this.valid(this.code("V.ERP.0426.013", "gradeCor"), vo.getGradeCor());
            this.valid(this.code("V.ERP.0426.014", "loteFabricacao"), vo.getLoteFabricacao());
            this.valid(this.code("V.ERP.0426.015", "dataMovimentacao"), vo.getDataMovimentacao());
        }
    }

    private void validFichasTecnicas(ItemComunicadoProducao vo) {
        for (final FichaTecItemComProducao ficha : vo.getFichasTecnicas()) {
            InterfaceFichaTecnica f = new InterfaceFichaTecnica(){

                @Override
                public ModeloFichaTecnica getModeloFichaTecnica() {
                    return ficha.getModeloFichaTecnica();
                }

                @Override
                public List<InterfaceFichaTecnicaValor> getItens() {
                    LinkedList<InterfaceFichaTecnicaValor> r = new LinkedList<InterfaceFichaTecnicaValor>();
                    for (final ValorFichaTecItemComProducao valor : ficha.getValoresFichaTec()) {
                        r.add(new InterfaceFichaTecnicaValor(){

                            @Override
                            public String getDescricao() {
                                return valor.getChave();
                            }

                            @Override
                            public String getValor() {
                                return valor.getValor();
                            }

                            @Override
                            public ItemModFichaTecVlrPad getValorInfPadrao() {
                                return valor.getVlrPadraoSelecionado();
                            }

                            @Override
                            public Short getValorObrigatorio() {
                                return valor.getValorObrigatorio();
                            }
                        });
                    }
                    return r;
                }
            };
            this.valid((ValidGenericDTOImpl)this.validFichaTecnica, f);
        }
    }
}

