/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.contasalariocolaborador;

import com.touchcomp.basementor.model.vo.ContaSalarioColaborador;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import org.springframework.stereotype.Component;

@Component
public class ValidContaSalarioColaborador
extends ValidGenericEntitiesImpl<ContaSalarioColaborador> {
    @Override
    protected void isValid(ContaSalarioColaborador vo) {
        this.valid(this.code("V.ERP.1246.002", "pessoa"), vo.getPessoa());
        this.valid(this.code("V.ERP.1246.003", "agencia"), vo.getAgencia());
        this.valid(this.code("V.ERP.1246.004", "contaCorrente"), vo.getContaCorrente());
        if (vo.getContaCorrente() != null && !ToolString.stringIsANumber((String)vo.getContaCorrente()).booleanValue()) {
            this.addError(this.code("V.ERP.1246.005", "contaCorrente"), vo.getContaCorrente());
        }
        this.valid(this.code("V.ERP.1246.006", "instituicaoValor"), vo.getInstituicaoValor());
        this.valid(this.code("V.ERP.1246.007", "classificacaoContaBancaria"), vo.getClassificacaoContaBancaria());
        this.valid(this.code("V.ERP.1246.008", "tipoConta"), vo.getTipoConta());
        if (TMethods.isStrWithData((String)vo.getCnpj()) && !ValidadeCPFCNPJ.isValid(vo.getCnpj())) {
            this.addError(this.code("V.ERP.1246.009", "cnpj"), vo.getCnpj());
        }
    }

    @Override
    public String getSimpleName() {
        return "1246 - Manuten\u00e7\u00e3o contas banc\u00e1rias";
    }
}

