/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.controlesolicitacaoservico;

import com.touchcomp.basementor.model.vo.ControleSolicitacaoServico;
import com.touchcomp.basementor.model.vo.ItemControleSolicitacaoServico;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class ValidControleSolicitacaoServico
extends ValidGenericEntitiesImpl<ControleSolicitacaoServico> {
    @Override
    protected void isValid(ControleSolicitacaoServico vo) {
        if (vo.getItemControleSolicitacaoService() != null && !vo.getItemControleSolicitacaoService().isEmpty()) {
            for (ItemControleSolicitacaoServico item : vo.getItemControleSolicitacaoService()) {
                if (this.isAffirmative(item.getAprovado())) {
                    this.valid(this.code("V.ERP.1161.001", item.getSolicitacaoServico().getIdentificador()), item.getOrdemServico().getDataProgramada());
                    this.valid(this.code("V.ERP.1161.002", item.getSolicitacaoServico().getIdentificador()), item.getOrdemServico().getDataPrevisao());
                    if (item.getOrdemServico().getDataProgramada() != null && item.getOrdemServico().getDataEmissao() != null) {
                        this.validBefore(this.code("V.ERP.1161.003", item.getSolicitacaoServico().getIdentificador()), ToolDate.dataSemHora((Date)item.getOrdemServico().getDataProgramada()), item.getOrdemServico().getDataEmissao(), new Object[0]);
                    }
                    this.valid(this.code("V.ERP.1161.004", item.getSolicitacaoServico().getIdentificador()), item.getOrdemServico().getDescricaoServico());
                    this.valid(this.code("V.ERP.1161.005", item.getSolicitacaoServico().getIdentificador()), item.getOrdemServico().getResponsavel());
                    this.valid(this.code("V.ERP.1161.006", item.getSolicitacaoServico().getIdentificador()), item.getOrdemServico().getSetorExecutante());
                    if (item.getOrdemServico().getSetorExecutante() != null && item.getOrdemServico().getSetorExecutante().getFornecedor() != null && item.getOrdemServico().getFornecedor() == null) {
                        this.addError(this.code("V.ERP.1161.007", item.getSolicitacaoServico().getIdentificador()), item.getOrdemServico().getFornecedor());
                    }
                    this.valid(this.code("V.ERP.1161.008", item.getSolicitacaoServico().getIdentificador()), item.getOrdemServico().getEquipamento());
                    this.valid(this.code("V.ERP.1161.009", item.getSolicitacaoServico().getIdentificador()), item.getOrdemServico().getCentroCusto());
                    continue;
                }
                this.valid(this.code("V.ERP.1161.010", item.getSolicitacaoServico().getIdentificador()), item.getAutorizadorReprovacao());
                this.valid(this.code("V.ERP.1161.011", item.getSolicitacaoServico().getIdentificador()), item.getMotivoReprovacao());
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "1161 - Controle Solicita\u00e7\u00e3o Servi\u00e7o";
    }
}

