/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.gradeformulaproduto;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.tipoproducao.EnumConstTipoProducao;
import com.touchcomp.basementor.constants.enums.tipoproducaosped.EnumConstTipoProducaoSped;
import com.touchcomp.basementor.model.vo.GradeFormProdTpSpedProd;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemPerdaFormProduto;
import com.touchcomp.basementor.model.vo.ItemSobraFormProduto;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ValidGradeFormulaProduto
extends ValidGenericEntitiesImpl<GradeFormulaProduto> {
    @Override
    protected void isValid(GradeFormulaProduto vo) {
        this.valid(this.code("V.ERP.0425.001", "descricao"), vo.getDescricao());
        this.valid(this.code("V.ERP.0425.002", "dataVigInicial"), vo.getDataVigInicial());
        if (this.valid(this.code("V.ERP.0425.003", "ativo"), vo.getAtivo()) && TMethods.isNegative((Number)vo.getAtivo())) {
            this.valid(this.code("V.ERP.0425.004", "dataVigFinal"), vo.getDataVigFinal());
        }
        this.valid(this.code("V.ERP.0425.005", "gradeCor"), vo.getGradeCor());
        if (this.valid(this.code("V.ERP.0425.006", "itemGradeFormulaProduto"), (Object)vo.getItemGradeFormulaProduto())) {
            this.validarItensFormula(vo);
            this.validarItensTipoProducao(vo);
        }
        if (this.valid(this.code("V.ERP.0425.007", "gradeFormProdTpSpedProd"), (Object)vo.getGradeFormProdTpSpedProd())) {
            this.validarTipoItemSped(vo);
        }
        if (this.valid(this.code("V.ERP.0425.008", "itemPerda"), (Object)vo.getItemPerda())) {
            this.validarItensPerda(vo);
        }
        if (this.valid(this.code("V.ERP.0425.009", "itemSobra"), (Object)vo.getItemSobra())) {
            this.validarItensSobra(vo);
        }
        if (this.isEquals(vo.getFormulacaoSemMaterial(), EnumConstantsMentorSimNao.NAO.getValue())) {
            this.validNotEmpty(this.code("V.ERP.0425.034"), vo.getItemGradeFormulaProduto());
        }
        if (this.isEquals(vo.getFormulacaoSemMaterial(), EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isWithData((Collection)vo.getItemGradeFormulaProduto())) {
            this.addError(this.code("V.ERP.0425.035"), vo.getItemGradeFormulaProduto());
        }
    }

    private void validarItensTipoProducao(GradeFormulaProduto vo) {
        Optional<ItemGradeFormulaProduto> found;
        Optional<GradeFormProdTpSpedProd> tipoDesmanche = this.findIt(EnumConstTipoProducaoSped.PRODUCAO_INTERNA_DESMANCHE, vo.getGradeFormProdTpSpedProd());
        Optional<GradeFormProdTpSpedProd> tipoProdConj = this.findIt(EnumConstTipoProducaoSped.PRODUCAO_EXTERNA_INDUSTRIALIZACAO_CONJUNTA, vo.getGradeFormProdTpSpedProd());
        Optional<GradeFormProdTpSpedProd> tipoProdConjExt = this.findIt(EnumConstTipoProducaoSped.PRODUCAO_INTERNA_CONJUNTA, vo.getGradeFormProdTpSpedProd());
        if (tipoDesmanche.isPresent()) {
            if (vo.getItemGradeFormulaProduto().size() != 1) {
                this.addError(this.code("V.ERP.0425.010", "tiposDefeitos"), vo);
            }
            if (TMethods.isWithData((Collection)vo.getItemGradeFormulaProduto()) && !((ItemGradeFormulaProduto)vo.getItemGradeFormulaProduto().get(0)).getGradeCor().equals((Object)vo.getGradeCor())) {
                this.addError(this.code("V.ERP.0425.011", "tiposDefeitos"), vo);
            }
            if (vo.getItemSobra() != null) {
                for (ItemSobraFormProduto itemS : vo.getItemSobra()) {
                    this.validGreather0(this.code("V.ERP.0425.012", "percentualCustoDesmanche"), itemS.getPercentualCustoDesmanche());
                }
            }
        }
        if (tipoDesmanche.isPresent() || tipoProdConj.isPresent() || tipoProdConjExt.isPresent()) {
            this.valid(this.code("V.ERP.0425.033", "tipoRateioDesmProdConjunta"), vo.getTipoRateioDesmProdConjunta());
        }
        Optional<GradeFormProdTpSpedProd> tipoProdInd = this.findIt(EnumConstTipoProducaoSped.PRODUCAO_EXTERNA_INDUSTRIALIZACAO, vo.getGradeFormProdTpSpedProd());
        Optional<GradeFormProdTpSpedProd> tipoProdInt = this.findIt(EnumConstTipoProducaoSped.PRODUCAO_INTERNA, vo.getGradeFormProdTpSpedProd());
        if ((tipoProdInd.isPresent() || tipoProdInt.isPresent()) && (found = vo.getItemGradeFormulaProduto().stream().filter(i -> i.getGradeCor().equals((Object)vo.getGradeCor())).findAny()).isPresent()) {
            this.addError(this.code("V.ERP.0425.013", "gradeCor"), vo);
        }
    }

    private Optional<GradeFormProdTpSpedProd> findIt(EnumConstTipoProducaoSped enumConstTipoProducaoSped, List<GradeFormProdTpSpedProd> gradeFormProdTpSpedProd) {
        return gradeFormProdTpSpedProd.stream().filter(g -> g.getTipoProducaoSped().getCodigo().equals(enumConstTipoProducaoSped.value)).findFirst();
    }

    private void validarItensFormula(GradeFormulaProduto vo) {
        for (ItemGradeFormulaProduto it : vo.getItemGradeFormulaProduto()) {
            this.valid(this.code("V.ERP.0425.014", "naturezaRequisicao", it.getGradeCor()), it.getNaturezaRequisicao());
            this.validGreather0(this.code("V.ERP.0425.015", "quantidade", it.getGradeCor()), it.getQuantidade());
            this.valid(this.code("V.ERP.0425.023", "altura", it.getGradeCor()), it.getAltura());
            this.valid(this.code("V.ERP.0425.024", "comprimento", it.getGradeCor()), it.getComprimento());
            this.valid(this.code("V.ERP.0425.025", "indice", it.getGradeCor()), it.getIndice());
            this.valid(this.code("V.ERP.0425.026", "largura", it.getGradeCor()), it.getLargura());
            this.valid(this.code("V.ERP.0425.027", "naoRequisitarAutomatico", it.getGradeCor()), it.getNaoRequisitarAutomatico());
            this.valid(this.code("V.ERP.0425.028", "naoUtilizarPesagem", it.getGradeCor()), it.getNaoUtilizarPesagem());
            this.valid(this.code("V.ERP.0425.029", "percAdicional", it.getGradeCor()), it.getPercAdicional());
            this.valid(this.code("V.ERP.0425.030", "qtdReferencia", it.getGradeCor()), it.getQtdReferencia());
            this.valid(this.code("V.ERP.0425.031", "tipoEstoque", it.getGradeCor()), it.getTipoEstoque());
            this.valid(this.code("V.ERP.0425.032", "volume", it.getGradeCor()), it.getVolume());
        }
    }

    private void validarItensPerda(GradeFormulaProduto vo) {
        for (ItemPerdaFormProduto it : vo.getItemPerda()) {
            this.valid(this.code("V.ERP.0425.016", "gradeFormulaProduto"), it.getGradeFormulaProduto());
            this.valid(this.code("V.ERP.0425.017", "tipoProducao", it.getGradeFormulaProduto()), it.getTipoProducao());
            this.valid(this.code("V.ERP.0425.018", "tiposDefeitos", it.getGradeFormulaProduto()), it.getTiposDefeitos());
            this.valid(this.code("V.ERP.0425.022", "estimativa", it.getGradeFormulaProduto()), it.getEstimativa());
        }
    }

    private void validarItensSobra(GradeFormulaProduto vo) {
        for (ItemSobraFormProduto it : vo.getItemSobra()) {
            this.valid(this.code("V.ERP.0425.019", "gradeCor"), it.getGradeCor());
            if (!this.valid(this.code("V.ERP.0425.020", "tipoProducao", it.getGradeCor()), it.getTipoProducao()) || !this.isEquals(it.getTipoProducao().getTipo(), EnumConstTipoProducao.REFUGO.getValue()) && !this.isEquals(it.getTipoProducao().getTipo(), EnumConstTipoProducao.SOBRA.getValue()) || it.getTiposDefeitos() != null) continue;
            this.addError(this.code("V.ERP.0425.021", "tiposDefeitos", it.getGradeCor()), it.getTiposDefeitos());
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validarTipoItemSped(GradeFormulaProduto vo) {
        for (GradeFormProdTpSpedProd gtp : vo.getGradeFormProdTpSpedProd()) {
            this.valid(this.code("V.ERP.0425.022", "tipoProducaoSped"), gtp.getTipoProducaoSped());
        }
    }
}

