/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.leadtimefornecedor;

import com.touchcomp.basementor.model.vo.LeadTimeFornProduto;
import com.touchcomp.basementor.model.vo.LeadTimeFornProdutoInfFiscal;
import com.touchcomp.basementor.model.vo.LeadTimeFornecedor;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidLeadTimeFornecedor
extends ValidGenericEntitiesImpl<LeadTimeFornecedor> {
    @Override
    protected void isValid(LeadTimeFornecedor vo) {
        this.valid(this.code("V.ERP.0833.001", "unidadeFatFornecedor"), vo.getUnidadeFatFornecedor());
        this.validNotEmpty(this.code("V.ERP.0833.002", "leadTimeFornEmpresa"), vo.getLeadTimeFornEmpresa());
        this.validNotEmpty(this.code("V.ERP.0833.003", "leadTimeFornProduto"), vo.getLeadTimeFornProduto());
        this.validarProdutos(vo.getLeadTimeFornProduto());
    }

    private void validarProdutos(List<LeadTimeFornProduto> produtos) {
        if (produtos != null) {
            for (LeadTimeFornProduto item : produtos) {
                if (!TMethods.isAffirmative((Number)item.getAquisicaoPreferencial())) continue;
                this.validNotEmpty(this.code("V.ERP.0833.004", "infFiscalLeadTime"), item.getInfFiscalLeadTime());
                if (item.getInfFiscalLeadTime() == null) continue;
                for (LeadTimeFornProdutoInfFiscal infFiscal : item.getInfFiscalLeadTime()) {
                    this.valid(this.code("V.ERP.0833.005", "motivoAqPref"), infFiscal.getMotivoAqPref());
                }
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "833 - Lead Time Produtos";
    }
}

