/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.movimentocentrocustocolaborador;

import com.touchcomp.basementor.model.vo.ItemMovCentroCustoColaborador;
import com.touchcomp.basementor.model.vo.MovimentoCentroCustoColaborador;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class ValidMovimentoCentroCustoColaborador
extends ValidGenericEntitiesImpl<MovimentoCentroCustoColaborador> {
    @Override
    protected void isValid(MovimentoCentroCustoColaborador vo) {
        this.valid(this.code("V.ERP.1351.001", "periodoAlocacao"), vo.getPeriodoAlocacao());
        this.valid(this.code("V.ERP.1351.002", "centroCusto"), vo.getCentroCusto());
        this.validNotEmpty(this.code("V.ERP.1351.003", "movsCentroCusto"), vo.getMovsCentroCusto());
        if (vo.getPeriodoAlocacao() != null && vo.getMovsCentroCusto() != null) {
            Date periodoInicial = ToolDate.getDataInicial((Date)vo.getPeriodoAlocacao());
            Date periodoFinal = ToolDate.getDataFinal((Date)vo.getPeriodoAlocacao());
            for (ItemMovCentroCustoColaborador i : vo.getMovsCentroCusto()) {
                if (i.getNrDiasAlocado() < 0.0) {
                    this.newMessageItem(this.code("V.ERP.1351.004", i.getColaborador().toString()), i.getColaborador());
                }
                this.valid(this.code("V.ERP.1351.006", "dataInicio"), i.getDataInicio());
                this.valid(this.code("V.ERP.1351.007", "dataFim"), i.getDataFinal());
                if (i.getDataInicio() == null || i.getDataFinal() == null || !i.getDataInicio().before(periodoInicial) && !i.getDataFinal().after(periodoFinal)) continue;
                this.newMessageItem(this.code("V.ERP.1351.005", i.getColaborador().toString()), i.getColaborador());
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "Movimentacao Colaborador por Centro Custo";
    }
}

