/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.naturezaoperacao;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.naturezaoperacao.EnumConstNatOpEntSaidaFaturamento;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeFinalidadeEmissao;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoEmpresa;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Iterator;
import org.springframework.stereotype.Component;

@Component
public class ValidNaturezaOperacao
extends ValidGenericEntitiesImpl<NaturezaOperacao> {
    @Override
    protected void isValid(NaturezaOperacao entity) {
        Iterator iterator;
        this.valid(this.code("V.ERP.0102.001", "descricao"), entity.getDescricao());
        this.valid(this.code("V.ERP.0102.002", "entradaSaida"), entity.getEntradaSaida());
        this.valid(this.code("V.ERP.0102.003", "tipoEstoque"), entity.getTipoEstoque());
        this.valid(this.code("V.ERP.0102.004", "descricaoAuxiliar"), entity.getDescricaoAuxiliar());
        if (this.valid(this.code("V.ERP.0102.005", "finalidadeEmNFe"), entity.getFinalidadeEmNFe()) && this.isAffirmative(entity.getFinalidadeEmNFe().getExigeTipoFinalidade())) {
            this.valid(this.code("V.ERP.0102.009", "finalidadeEmNFeTipo"), entity.getFinalidadeEmNFeTipo());
            this.validaTipoFinalidadeNFe(entity);
        }
        if (entity.getEntradaSaida() != null && (this.isEqualsNumber(entity.getEntradaSaida(), EnumConstNatOpEntSaidaFaturamento.ENT_SAI_FATURAMENTO_SAIDA.getValue()) || this.isEqualsNumber(entity.getEntradaSaida(), EnumConstNatOpEntSaidaFaturamento.ENT_SAI_FATURAMENTO_ENTRADA.getValue())) && this.isEqualsNumber(entity.getPermitirInfSerieNota(), EnumConstantsMentorSimNao.NAO.getValue()) && (iterator = entity.getEmpresas().iterator()).hasNext()) {
            NaturezaOperacaoEmpresa empresa = (NaturezaOperacaoEmpresa)iterator.next();
            this.valid(this.code("V.ERP.0102.006", "serie"), empresa.getSerie());
        }
        this.valid(this.code("V.ERP.0102.007", "modeloDocFiscal"), entity.getModeloDocFiscal());
        if (entity.getTipoEstoque() != null && (entity.getTipoEstoque().equals((short)1) || entity.getTipoEstoque().equals((short)2) || entity.getTipoEstoque().equals((short)4) || entity.getTipoEstoque().equals((short)5) || entity.getTipoEstoque().equals((short)6) || entity.getTipoEstoque().equals((short)8) || entity.getTipoEstoque().equals((short)9) || entity.getTipoEstoque().equals((short)10) || entity.getTipoEstoque().equals((short)11))) {
            this.valid(this.code("V.ERP.0102.008", "tipoMovimento"), entity.getTipoMovimento());
        }
    }

    @Override
    public String getSimpleName() {
        return "Natureza Opera\u00e7\u00e3o";
    }

    private void validaTipoFinalidadeNFe(NaturezaOperacao entity) {
        if (entity.getEntradaSaida() == null) {
            return;
        }
        EnumConstNFeFinalidadeEmissao tipo = EnumConstNFeFinalidadeEmissao.get((Object)entity.getFinalidadeEmNFe().getCodigo());
        if (tipo.isCredito() && !this.isEquals(entity.getEntradaSaida(), EnumConstNatOpEntSaidaFaturamento.ENT_SAI_FATURAMENTO_ENTRADA.getValue())) {
            this.addError(this.code("V.ERP.0102.011", "finalidadeEmNFeTipo"), tipo);
        }
        if (tipo.isDebito() && !this.isEquals(entity.getEntradaSaida(), EnumConstNatOpEntSaidaFaturamento.ENT_SAI_FATURAMENTO_SAIDA.getValue())) {
            this.addError(this.code("V.ERP.0102.010", "finalidadeEmNFeTipo"), tipo);
        }
    }
}

