/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.ncm;

import com.touchcomp.basementor.model.vo.Ncm;
import com.touchcomp.basementor.model.vo.NcmAliquotaUF;
import com.touchcomp.basementor.model.vo.RegraExcecaoCbsIbs;
import com.touchcomp.basementor.model.vo.RegraExcecaoNCM;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class ValidNcm
extends ValidGenericEntitiesImpl<Ncm> {
    @Override
    protected void isValid(Ncm vo) {
        this.valid(this.code("V.ERP.0167.001", "codigo"), vo.getCodigo());
        this.validLenght(this.code("V.ERP.0167.002", "codigo", 8), vo.getCodigo(), 8, new Object[0]);
        this.valid(this.code("V.ERP.0167.003", "descricao"), vo.getDescricao());
        if (ToolMethods.isWithData((Collection)vo.getRegraExcecaoNCM())) {
            this.validarRegras(vo);
        }
        if (ToolMethods.isWithData((Collection)vo.getRegrasExcecoesCbsIbs())) {
            this.validarRegrasCbsIbs(vo);
        }
        if (ToolMethods.isWithData((Collection)vo.getAliquotasUF())) {
            this.validarAliquotas(vo);
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validarRegras(Ncm vo) {
        for (RegraExcecaoNCM r : vo.getRegraExcecaoNCM()) {
            this.valid(this.code("V.ERP.0167.004", "codigo"), r.getCodigo());
            this.validLenght(this.code("V.ERP.0167.005", "codigo", 3), r.getCodigo(), 3, new Object[0]);
            this.valid(this.code("V.ERP.0167.006", "descricao"), r.getDescricao());
        }
    }

    private void validarRegrasCbsIbs(Ncm vo) {
        for (RegraExcecaoCbsIbs rr : vo.getRegrasExcecoesCbsIbs()) {
            String regex;
            Pattern pattern;
            Matcher matcher;
            if (!this.valid(this.code("V.ERP.0167.007", "descricao"), rr.getDescricao()) || (matcher = (pattern = Pattern.compile(regex = "^ANEXO\\s+[IVXLCDM]+(?:\\s+(?:EX|ARTIGO)\\s+\\d+)?$")).matcher(rr.getDescricao())).matches()) continue;
            this.addError(this.code("V.ERP.0167.008"), vo);
        }
    }

    private void validarAliquotas(Ncm vo) {
        for (NcmAliquotaUF pp : vo.getAliquotasUF()) {
            this.validMin(this.code("V.ERP.0167.009", "aliquotaIcms"), pp.getAliquotaIcms(), 0.0);
        }
    }
}

