/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.opcoescontabeis;

import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisDifal;
import com.touchcomp.basementor.model.vo.OpcoesContabeisImpostosRetidos;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.planoconta.ValidPlanoConta;
import java.util.Collection;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ValidOpcoesContabeis
extends ValidGenericEntitiesImpl<OpcoesContabeis> {
    @Override
    protected void isValid(OpcoesContabeis vo) {
        if (vo != null && vo.getOpcoesContabeisGerContaPessoa() != null) {
            if (!this.checarConta(vo.getOpcoesContabeisGerContaPessoa().getPlanoAntecipCliente())) {
                this.addError(this.code("V.ERP.1757.001"), vo);
            }
            if (!this.checarConta(vo.getOpcoesContabeisGerContaPessoa().getPlanoAntecipFornecedor())) {
                this.addError(this.code("V.ERP.1757.002"), vo);
            }
            if (!this.checarConta(vo.getOpcoesContabeisGerContaPessoa().getPlanoContaCliente())) {
                this.addError(this.code("V.ERP.1757.003"), vo);
            }
            if (!this.checarConta(vo.getOpcoesContabeisGerContaPessoa().getPlanoContaCooperado())) {
                this.addError(this.code("V.ERP.1757.004"), vo);
            }
            if (!this.checarConta(vo.getOpcoesContabeisGerContaPessoa().getPlanoContaFornecedor())) {
                this.addError(this.code("V.ERP.1757.005"), vo);
            }
            if (!this.checarConta(vo.getOpcoesContabeisGerContaPessoa().getPlanoContaInstFinanceira())) {
                this.addError(this.code("V.ERP.1757.006"), vo);
            }
            if (!this.checarConta(vo.getOpcoesContabeisGerContaPessoa().getPlanoContaMotorisa())) {
                this.addError(this.code("V.ERP.1757.007"), vo);
            }
            if (!this.checarConta(vo.getOpcoesContabeisGerContaPessoa().getPlanoContaRepresentante())) {
                this.addError(this.code("V.ERP.1757.008"), vo);
            }
            if (!this.checarConta(vo.getOpcoesContabeisGerContaPessoa().getPlanoContaTomador())) {
                this.addError(this.code("V.ERP.1757.009"), vo);
            }
            if (!this.checarConta(vo.getOpcoesContabeisGerContaPessoa().getPlanoContaTransportador())) {
                this.addError(this.code("V.ERP.1757.010"), vo);
            }
        }
        this.validarImpostosRetidos(vo);
        this.validarDIFAL(vo);
    }

    private void validarImpostosRetidos(OpcoesContabeis vo) {
        if (TMethods.isWithData((Collection)vo.getOpcoesImpostosRetidos())) {
            for (OpcoesContabeisImpostosRetidos impRet : vo.getOpcoesImpostosRetidos()) {
                Optional<OpcoesContabeisImpostosRetidos> impDuplicado;
                this.valid(this.code("V.ERP.1757.011", "diaVencimentoImpostoRetido"), impRet.getDiaVencimentoImpostoRetido());
                this.valid(this.code("V.ERP.1757.011", "pessoaImpostoRetido"), impRet.getPessoaImpostoRetido());
                this.valid(this.code("V.ERP.1757.011", "planoContaGerencialImpostoRetido"), impRet.getPlanoContaGerencialImpostoRetido());
                this.valid(this.code("V.ERP.1757.011", "planoContaImpostoRetido"), impRet.getPlanoContaImpostoRetido());
                this.valid(this.code("V.ERP.1757.011", "tipoImpostoRetido"), impRet.getTipoImpostoRetido());
                if (!TMethods.isNotNull((Object)impRet.getTipoImpostoRetido()).booleanValue() || !(impDuplicado = vo.getOpcoesImpostosRetidos().stream().filter(i -> TMethods.isEquals((Object)i.getTipoImpostoRetido(), (Object)impRet.getTipoImpostoRetido()) && !TMethods.isEquals((Object)impRet, (Object)i)).findFirst()).isPresent()) continue;
                this.addError(this.code("V.ERP.1757.012"), vo);
            }
        }
    }

    private void validarDIFAL(OpcoesContabeis vo) {
        if (TMethods.isWithData((Collection)vo.getOpcoesContabeisDifal())) {
            for (OpcoesContabeisDifal difal : vo.getOpcoesContabeisDifal()) {
                Optional<OpcoesContabeisDifal> difalDup;
                this.valid(this.code("V.ERP.1757.013", "diaDifal"), difal.getDiaDifal());
                this.valid(this.code("V.ERP.1757.013", "pessoa"), difal.getPessoa());
                this.valid(this.code("V.ERP.1757.013", "planoGerencial"), difal.getPlanoGerencial());
                this.valid(this.code("V.ERP.1757.013", "planoConta"), difal.getPlanoConta());
                this.valid(this.code("V.ERP.1757.013", "uf"), difal.getUf());
                if (!TMethods.isNotNull((Object)difal.getUf()).booleanValue() || !(difalDup = vo.getOpcoesContabeisDifal().stream().filter(i -> TMethods.isEquals((Object)i.getUf(), (Object)difal.getUf()) && !TMethods.isEquals((Object)difal, (Object)i)).findFirst()).isPresent()) continue;
                this.addError(this.code("V.ERP.1757.014"), vo);
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "1757 - Op\u00e7\u00f5es Cont\u00e1beis";
    }

    private boolean checarConta(PlanoConta pc) {
        if (pc == null) {
            return true;
        }
        if (ValidPlanoConta.isAnalitica(pc)) {
            return true;
        }
        return ValidPlanoConta.isNivel4(pc);
    }
}

