/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.pacoteorcamentario;

import com.touchcomp.basementor.model.vo.PacoteOrcamentario;
import com.touchcomp.basementor.model.vo.PacoteOrcamentarioPCGer;
import com.touchcomp.basementor.model.vo.PacoteOrcamentarioPCGerCC;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class ValidPacoteOrcamentario
extends ValidGenericEntitiesImpl<PacoteOrcamentario> {
    @Override
    protected void isValid(PacoteOrcamentario entity) {
        this.valid(this.code("V.ERP.1822.001", "descricao"), entity.getDescricao());
        this.valid(this.code("V.ERP.1822.002", "usuario"), entity.getUsuario());
        this.valid(this.code("V.ERP.1822.003", "planosConta"), (Object)entity.getPlanosConta());
        this.validarPlanosConta(entity.getPlanosConta());
    }

    private void validarPlanosConta(List<PacoteOrcamentarioPCGer> planosConta) {
        if (planosConta == null) {
            return;
        }
        planosConta.forEach(i -> {
            this.valid(this.code("V.ERP.1822.004", "planosConta"), i.getPlanoContaGerencial());
            this.validCentrosCusto(i.getCentrosCusto());
        });
        this.validarPCCCRepetidos(planosConta);
    }

    private void validCentrosCusto(List<PacoteOrcamentarioPCGerCC> centrosCusto) {
        if (centrosCusto == null) {
            return;
        }
        for (PacoteOrcamentarioPCGerCC cc : centrosCusto) {
            this.valid(this.code("V.ERP.1822.005", "centroCusto"), cc.getCentroCusto());
        }
    }

    @Override
    public String getSimpleName() {
        return "1822";
    }

    private void validarPCCCRepetidos(List<PacoteOrcamentarioPCGer> planosConta) {
        HashMap<Object, Integer> h = new HashMap<Object, Integer>();
        for (PacoteOrcamentarioPCGer p : planosConta) {
            Integer found = h.get(p.getPlanoContaGerencial());
            if (found == null) {
                found = 0;
            }
            Integer n = found;
            found = found + 1;
            h.put(p.getPlanoContaGerencial(), found);
            this.validarCCRepetidos(p.getCentrosCusto());
        }
        this.checkAndAddMessage(h, "V.ERP.1822.004", "planoContaGerencial");
    }

    private void validarCCRepetidos(List<PacoteOrcamentarioPCGerCC> centrosCusto) {
        HashMap<Object, Integer> h = new HashMap<Object, Integer>();
        for (PacoteOrcamentarioPCGerCC p : centrosCusto) {
            Integer found = h.get(p.getCentroCusto());
            if (found == null) {
                found = 0;
            }
            Integer n = found;
            found = found + 1;
            h.put(p.getCentroCusto(), found);
        }
        this.checkAndAddMessage(h, "V.ERP.1822.005", "centroCusto");
    }

    private void checkAndAddMessage(HashMap<Object, Integer> h, String code, String fieldName) {
        Set<Object> keys = h.keySet();
        for (Object key : keys) {
            Integer nr = h.get(key);
            if (nr <= 1) continue;
            this.addError(this.code(code, fieldName), h.get(key));
        }
    }
}

