/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.parametrizacaocodigobem;

import com.touchcomp.basementor.constants.enums.bem.parametrizacaocodigobem.EnumConstTipoItemParametrizacaoCodigoBem;
import com.touchcomp.basementor.model.vo.ItemParametrizacaoCodigoBem;
import com.touchcomp.basementor.model.vo.ParametrizacaoCodigoBem;
import com.touchcomp.basementor.model.vo.ParametrizacaoCodigoBemTipoBem;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidParametrizacaoCodigoBem
extends ValidGenericEntitiesImpl<ParametrizacaoCodigoBem> {
    @Override
    protected void isValid(ParametrizacaoCodigoBem entity) {
        this.validNotEmpty(this.code("V.ERP.2028.001", "itemParametrizacaoCodigoBem"), entity.getItemParametrizacaoCodigoBem());
        this.validarItensParametrizacoes(entity);
        this.validNotEmpty(this.code("V.ERP.2028.007", "tipoBem"), entity.getTipoBem());
        this.validarTipoBem(entity);
    }

    private void validarItensParametrizacoes(ParametrizacaoCodigoBem entity) {
        if (TMethods.isWithData((Collection)entity.getItemParametrizacaoCodigoBem())) {
            for (ItemParametrizacaoCodigoBem item : entity.getItemParametrizacaoCodigoBem()) {
                this.valid(this.code("V.ERP.2028.002", "itemParametrizacaoCodigoBem.mascara"), item.getMascara());
                this.valid(this.code("V.ERP.2028.003", "itemParametrizacaoCodigoBem.tipoVariavelCodigoBem"), item.getTipoVariavelCodigoBem());
                if (TMethods.isEquals((Object)item.getTipoVariavelCodigoBem(), (Object)EnumConstTipoItemParametrizacaoCodigoBem.TIPO_LETRA_VARIAVEL.getEnumId())) {
                    this.valid(this.code("V.ERP.2028.004", "itemParametrizacaoCodigoBem.variavelFixa"), item.getVariavelFixa());
                }
                if (TMethods.isAffirmative((Number)item.getFixo())) {
                    this.valid(this.code("V.ERP.2028.005", "itemParametrizacaoCodigoBem.variavelFixa"), item.getVariavelFixa());
                }
                if (!TMethods.isNotNull((Object)item.getVariavelFixa()).booleanValue() || !TMethods.isNotNull((Object)item.getMascara()).booleanValue()) continue;
                this.validNotEquals(this.code("V.ERP.2028.006", "itemParametrizacaoCodigoBem"), item.getVariavelFixa().length(), item.getMascara().length());
            }
        }
    }

    private void validarTipoBem(ParametrizacaoCodigoBem entity) {
        if (TMethods.isWithData((Collection)entity.getTipoBem())) {
            for (ParametrizacaoCodigoBemTipoBem item : entity.getTipoBem()) {
                this.valid(this.code("V.ERP.2028.008", "tipoBem.tipoBem"), item.getTipoBem());
                this.valid(this.code("V.ERP.2028.009", "tipoBem.conteudo"), item.getConteudo());
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "2028 - Parametriza\u00e7\u00e3o C\u00f3digo Bem";
    }
}

