/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.pedido;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstTipoTabelaPreco;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ItemPedidoEmbalagemProduto;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoModFiscal;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import java.util.Optional;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ValidItemPedido
extends ValidGenericEntitiesImpl<ItemPedido> {
    private OpcoesFaturamento opcoesFaturamento;

    @Override
    protected void isValid(ItemPedido vo) {
        this.validGreather0(this.code("V.ERP.1180.028"), vo.getValorUnitario());
        this.validMax(this.code("V.ERP.1180.066", "valorUnitario", String.valueOf(vo)), vo.getValorUnitario(), vo.getValorMaximo());
        this.validMin(this.code("V.ERP.1180.067", "valorUnitario", String.valueOf(vo)), vo.getValorUnitario(), vo.getValorMinimo());
        this.validGreather0(this.code("V.ERP.1180.029"), vo.getQuantidadeTotal());
        this.validGreather0(this.code("V.ERP.1180.030"), vo.getValorTotal());
        if (vo.getTipoCondicao() == 0) {
            this.validarItensPedidoNormal(vo);
        } else {
            this.validarItensPedidoItemEspecial(vo);
        }
        if (this.valid(this.code("V.ERP.1180.031"), vo.getPercComissao())) {
            if (vo.getPercComissaoMin() != null && vo.getPercComissao() < vo.getPercComissaoMin()) {
                this.addError(this.code("V.ERP.1180.059"), vo);
            }
            if (vo.getPercComissaoMax() != null && vo.getPercComissao() > vo.getPercComissaoMax()) {
                this.addError(this.code("V.ERP.1180.060"), vo);
            }
        }
        if (vo.getAnalisePrecoVenda() != null && vo.getAnalisePrecoVenda().getAnalisePrVendaPCPEnc() != null) {
            this.validGreather0(this.code("V.ERP.1180.061"), vo.getAnalisePrecoVenda().getAnalisePrVendaPCPEnc().getPesoBruto());
            this.validGreather0(this.code("V.ERP.1180.062"), vo.getAnalisePrecoVenda().getAnalisePrVendaPCPEnc().getPesoLiquido());
            this.validGreather0(this.code("V.ERP.1180.063"), vo.getAnalisePrecoVenda().getAnalisePrVendaPCPEnc().getPesoBrutoMateriais());
            this.validGreather0(this.code("V.ERP.1180.064"), vo.getAnalisePrecoVenda().getAnalisePrVendaPCPEnc().getPesoLiquidoMateriais());
        }
        if (vo.getTipoTabPreco() != null && vo.getTipoTabPreco().shortValue() == EnumConstTipoTabelaPreco.TABELA_PRECO_DINAMICA.getValue()) {
            this.valid(this.code("V.ERP.1180.031"), vo.getFormTabDinCalcComissao());
            this.valid(this.code("V.ERP.1180.032"), vo.getFormTabDinCalcPreco());
        }
        if (ToolMethods.isWithData((Collection)vo.getItemPedidoEmbalagemProduto())) {
            ItemPedidoEmbalagemProduto itemEmb = (ItemPedidoEmbalagemProduto)vo.getItemPedidoEmbalagemProduto().get(0);
            Double qtdePorEmbalagem = itemEmb.getQtdePorEmbalagem();
            int resto = vo.getQuantidadeTotal().intValue() % qtdePorEmbalagem.intValue();
            if ((double)resto > 0.0) {
                this.addError(this.code("V.ERP.1180.033"), vo);
            }
        }
        if (this.getOpcoesFaturamento() != null && TMethods.isAffirmative((Number)this.getOpcoesFaturamento().getUsarClassificacaoVendas())) {
            this.valid(this.code("V.ERP.1180.034"), vo.getClassificacaoVendas());
        }
        if (vo.getProduto() != null && this.isAffirmative(vo.getProduto().getQtdeNaoFracionada()) && vo.getQuantidadeTotal() != null && vo.getQuantidadeTotal() > Math.floor(vo.getQuantidadeTotal())) {
            this.addError(this.code("V.ERP.1180.033"), vo);
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validarItensPedidoNormal(ItemPedido vo) {
        this.valid(this.code("V.ERP.1180.035"), vo.getProduto());
        if (ToolMethods.isNotNull((Object)vo.getProduto().getTipoMedicamento()).booleanValue() && !ToolMethods.isStrWithData((String)vo.getProduto().getCodAnvisa())) {
            this.addError(this.code("V.ERP.0065.105"), vo);
        }
        this.valid(this.code("V.ERP.1180.036"), vo.getUnidadeMedida());
        if (vo.getProduto().getQtdMinVenda() > vo.getQuantidadeTotal() * vo.getFatorConversao()) {
            this.addError(this.code("V.ERP.1180.037"), vo);
        }
        if (this.getOpcoesFaturamento() != null && !TMethods.isAffirmative((Number)this.getOpcoesFaturamento().getPermitirSalvarSemModFiscal())) {
            this.valid(this.code("V.ERP.1180.038"), vo.getModeloFiscal());
            if (ToolMethods.isNotNull((Object)vo.getModeloFiscal()).booleanValue() && this.isEquals(vo.getModeloFiscal().getAtivo(), EnumConstantsMentorSimNao.NAO.getValue())) {
                this.addError(this.code("V.ERP.1180.048"), vo.getModeloFiscal());
            }
            if (vo.getPedido() != null && vo.getModeloFiscal() != null) {
                Optional<NaturezaOperacaoModFiscal> found = vo.getModeloFiscal().getNaturezaOperacao().stream().filter(nat -> nat.getNaturezaOperacao().equals((Object)vo.getPedido().getNaturezaOperacao())).findFirst();
                if (vo.getModeloFiscal() != null && !found.isPresent()) {
                    this.addError(this.code("V.ERP.1180.058", vo.getProduto()), vo.getModeloFiscal().getNaturezaOperacao());
                }
            }
        }
        if (vo.getProduto().getDataInicioFaturamento() != null && vo.getPedido() != null && vo.getPedido().getDataPrevisaoSaida().before(vo.getProduto().getDataInicioFaturamento())) {
            this.valid(this.code("V.ERP.1180.047"), vo);
        }
        if (this.validNotEmpty(this.code("V.ERP.1180.049"), vo.getGradeItemPedido())) {
            this.validGradesCores(vo);
        }
    }

    private void validarItensPedidoItemEspecial(ItemPedido vo) {
        this.valid(this.code("V.ERP.1180.039"), vo.getCodigoAux());
        this.valid(this.code("V.ERP.1180.040"), vo.getDescricaoAux());
    }

    public OpcoesFaturamento getOpcoesFaturamento() {
        return this.opcoesFaturamento;
    }

    public void setOpcoesFaturamento(OpcoesFaturamento opcoesFaturamento) {
        this.opcoesFaturamento = opcoesFaturamento;
    }

    private void validGradesCores(ItemPedido vo) {
        double qtdTotalItem = vo.getQuantidadeTotal();
        double qtdTotalGrade = 0.0;
        for (GradeItemPedido gi : vo.getGradeItemPedido()) {
            this.valid(this.code("V.ERP.1180.050"), gi.getGradeCor());
            this.valid(this.code("V.ERP.1180.051"), gi.getQuantidade());
            if (vo.getProduto() != null && this.isAffirmative(vo.getProduto().getQtdeNaoFracionada()) && gi.getQuantidade() != null && gi.getQuantidade() > Math.floor(gi.getQuantidade())) {
                this.addError(this.code("V.ERP.1180.033"), vo);
            }
            qtdTotalGrade += gi.getQuantidade().doubleValue();
        }
        qtdTotalItem = ToolFormatter.arrredondarNumero((Double)qtdTotalItem, (int)2);
        if (Math.abs((qtdTotalGrade = ToolFormatter.arrredondarNumero((Double)qtdTotalGrade, (int)2).doubleValue()) - qtdTotalItem) > 0.0) {
            this.addError(this.code("V.ERP.1180.052"), vo.getProduto());
        }
    }
}

