/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.pedidoalmoxarifado;

import com.touchcomp.basementor.model.vo.GradeItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.ItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.PedidoAlmoxarifado;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidPedidoAlmoxarifado
extends ValidGenericEntitiesImpl<PedidoAlmoxarifado> {
    @Override
    protected void isValid(PedidoAlmoxarifado vo) {
        OpcoesCompraSuprimentos op = this.getSharedObjects().getOpcoesCompraSuprimentos(vo.getEmpresa());
        if (op != null && this.isAffirmative(op.getUtilizarNatOpPedAlmox())) {
            this.valid(this.code("V.ERP.0287.004", "naturezaOperacao"), vo.getNaturezaOperacao());
        }
        if (vo.getNaturezaOperacao() != null && !this.isAffirmative(vo.getNaturezaOperacao().getNatOperacaoDispPedAlmox())) {
            this.addError(this.code("V.ERP.0287.010", "naturezaOperacao"), vo.getNaturezaOperacao());
        }
        this.valid(this.code("V.ERP.0287.001", "dataEmissao"), vo.getDataEmissao());
        this.valid(this.code("V.ERP.0287.002", "dataAgendamento"), vo.getDataAgendamento());
        this.valid(this.code("V.ERP.0287.004", "naturezaOperacao"), vo.getNaturezaOperacao());
        if (this.valid(this.code("V.ERP.0287.003", "itensPedido"), (Object)vo.getItensPedido())) {
            this.validItens(vo);
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validItens(PedidoAlmoxarifado vo) {
        for (ItemPedidoAlmoxarifado item : vo.getItensPedido()) {
            this.valid(this.code("V.ERP.0287.005", "itens.produto"), item.getProduto());
            this.valid(this.code("V.ERP.0287.006", "itens.getCentroCusto"), item.getCentroCusto());
            if (!this.valid(this.code("V.ERP.0287.007", "itens.grades"), (Object)item.getGradesItensAlmoxarifado())) continue;
            this.validGrades(item);
        }
    }

    private void validGrades(ItemPedidoAlmoxarifado item) {
        for (GradeItemPedidoAlmoxarifado g : item.getGradesItensAlmoxarifado()) {
            this.valid(this.code("V.ERP.0287.009", "gradeCor"), g.getGradeCor());
            this.validGreather0(this.code("V.ERP.0287.008", "g.getQuantidade"), g.getQuantidade());
        }
    }
}

