/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.planejamentomateriaisprodlin;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.GrupoPlanejamentoMateriaisLin;
import com.touchcomp.basementor.model.vo.ItemPlanejamentoProdLinhaProd;
import com.touchcomp.basementor.model.vo.PlanejamentoMateriaisProdLin;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidPlanejamentoMateriaisProdLin
extends ValidGenericEntitiesImpl<PlanejamentoMateriaisProdLin> {
    @Override
    protected void isValid(PlanejamentoMateriaisProdLin vo) {
        this.valid(this.code("V.ERP.2016.001", "descricao"), vo.getDescricao());
        this.valid(this.code("V.ERP.2016.002", "centroCusto"), vo.getCentroCusto());
        this.valid(this.code("V.ERP.2016.003", "dataConsulta"), vo.getDataConsulta());
        this.validNotEmpty(this.code("V.ERP.2016.004", "itensPlanProdLinha"), vo.getItensPlanProdLinha());
        this.validNotEmpty(this.code("V.ERP.2016.005", "gruposPlanejMat"), vo.getGruposPlanejMat());
        if (TMethods.isWithData((Collection)vo.getItensPlanProdLinha())) {
            for (ItemPlanejamentoProdLinhaProd item : vo.getItensPlanProdLinha()) {
                this.valid(this.code("V.ERP.2016.006", "planejProdLinha"), item.getPlanejProdLinha());
                if (TMethods.isNotNull((Object)item.getPlanejProdLinha()).booleanValue()) {
                    this.validNotEquals(this.code("V.ERP.2016.007", "travarProducao", String.valueOf(item.getPlanejProdLinha())), item.getPlanejProdLinha().getTravarProducao(), EnumConstantsMentorSimNao.SIM.getValue());
                }
                if (!TMethods.isNotNull((Object)item.getPlanejProdLinha()).booleanValue() || !TMethods.isWithData((Collection)item.getPlanejProdLinha().getPrevisaoConsProdutos()) && !TMethods.isNotNull((Object)item.getPlanejProdLinha().getGrupoNecCompra()).booleanValue() && !TMethods.isNotNull((Object)item.getPlanejProdLinha().getTransfEstoquePCPLinReserva()).booleanValue()) continue;
                this.addError(this.code("V.ERP.2016.010", "itensPlanProdLinha"), String.valueOf(item.getPlanejProdLinha()));
            }
        }
        if (TMethods.isWithData((Collection)vo.getGruposPlanejMat())) {
            for (GrupoPlanejamentoMateriaisLin grupo : vo.getGruposPlanejMat()) {
                this.valid(this.code("V.ERP.2016.008", "gruposPlanejMat.data"), grupo.getData());
            }
        }
        if (TMethods.isAffirmative((Number)vo.getLiberarReserva())) {
            this.valid(this.code("V.ERP.2016.009", "centroEstoque"), vo.getCentroEstoque());
        }
    }

    @Override
    public String getSimpleName() {
        return "2016 - PLanejamento Materiais Linha Produ\u00e7\u00e3o";
    }
}

