/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.planomanutencaoativo;

import com.touchcomp.basementor.constants.enums.tipopontocontrole.EnumConstTipoPontoControle;
import com.touchcomp.basementor.model.vo.AtivoDataUltimaManutencao;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.PreProcedimento;
import com.touchcomp.basementor.model.vo.PreProdutoPrevManutencao;
import com.touchcomp.basementor.model.vo.PreServicoProcedimento;
import com.touchcomp.basementor.model.vo.SetorExecutanteServicos;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidPlanoManutencaoAtivo
extends ValidGenericEntitiesImpl<PlanoManutencaoAtivo> {
    @Override
    protected void isValid(PlanoManutencaoAtivo vo) {
        this.valid(this.code("V.ERP.0124.001", "descricao"), vo.getDescricao());
        this.valid(this.code("V.ERP.0124.002", "tipoServico"), vo.getTipoServico());
        this.valid(this.code("V.ERP.0124.003", "tipoControle"), vo.getTipoControle());
        if (vo.getTipoControle() != null) {
            if (this.isEquals(vo.getTipoControle().getIdentificador(), EnumConstTipoPontoControle.TIPO_PONTO_ACUMULATIVO.getValue())) {
                this.valid(this.code("V.ERP.0124.004", "tipoPontoControle"), vo.getTipoPontoControle());
                this.validGreather0(this.code("V.ERP.0124.005", "limiteAlerta"), vo.getLimiteAlerta());
                this.validGreather0(this.code("V.ERP.0124.006", "limite"), vo.getLimite());
                if (vo.getLimite() > vo.getLimiteAlerta()) {
                    this.newMessageItem(this.code("V.ERP.0124.007", "limite"), vo.getLimite());
                }
            } else if (this.isEquals(vo.getTipoControle().getIdentificador(), EnumConstTipoPontoControle.TIPO_PONTO_PERIODICO.getValue())) {
                this.valid(this.code("V.ERP.0124.008", "periodicidade"), vo.getPeriodicidade());
            }
        }
        this.valid(this.code("V.ERP.0124.009", "setorExecutantesServicos"), (Object)vo.getSetorExecutantesServicos());
        if (vo.getSetorExecutantesServicos() != null) {
            if (!this.validaPreServicosProcedimentos(vo.getSetorExecutantesServicos()).booleanValue()) {
                this.newMessageItem(this.code("V.ERP.0124.010", "setorExecutantesServicos"), vo.getSetorExecutantesServicos());
            }
            if (!this.validaPreProcedimentos(vo.getSetorExecutantesServicos()).booleanValue()) {
                this.newMessageItem(this.code("V.ERP.0124.011", "setorExecutantesServicos"), vo.getSetorExecutantesServicos());
            }
            if (!this.validaQtdPreProduto(vo.getSetorExecutantesServicos()).booleanValue()) {
                this.newMessageItem(this.code("V.ERP.0124.012", "setorExecutantesServicos"), vo.getSetorExecutantesServicos());
            }
        }
        this.valid(this.code("V.ERP.0124.013", "ativos"), (Object)vo.getAtivos());
        if (vo.getAtivos() != null) {
            if (!this.validarAtivosSemCentroCusto(vo.getAtivos()).booleanValue()) {
                this.newMessageItem(this.code("V.ERP.0124.014", "ativos"), vo.getAtivos());
            }
            if (!this.validarDataUltimaManutencaoAtivo(vo.getAtivos()).booleanValue()) {
                this.newMessageItem(this.code("V.ERP.0124.015", "ativos"), vo.getAtivos());
            }
        }
    }

    Boolean validarAtivosSemCentroCusto(List<AtivoDataUltimaManutencao> ativos) {
        for (AtivoDataUltimaManutencao ativoDataUltimaManutencao : ativos) {
            if (ativoDataUltimaManutencao.getAtivo().getCentroCusto() != null) continue;
            return false;
        }
        return true;
    }

    Boolean validarDataUltimaManutencaoAtivo(List<AtivoDataUltimaManutencao> ativos) {
        for (AtivoDataUltimaManutencao ativoDataUltimaManutencao : ativos) {
            if (ativoDataUltimaManutencao.getDataUltimaManutencao() != null) continue;
            return false;
        }
        return true;
    }

    Boolean validaQtdPreProduto(List<SetorExecutanteServicos> setorExecutantesServicos) {
        for (SetorExecutanteServicos setorExecutanteServicos : setorExecutantesServicos) {
            for (PreServicoProcedimento preServicoProcedimento : setorExecutanteServicos.getPreServicoProcedimentos()) {
                for (PreProcedimento preProcedimento : preServicoProcedimento.getPreProcedimento()) {
                    for (PreProdutoPrevManutencao preProdutoPrevManutencao : preProcedimento.getPreProdutosPrevisaoManutencao()) {
                        if (preProdutoPrevManutencao.getQtdPrevista() != null && !(preProdutoPrevManutencao.getQtdPrevista() < 0.0)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    Boolean validaPreServicosProcedimentos(List<SetorExecutanteServicos> setorExecutantesServicos) {
        for (SetorExecutanteServicos setorExecutanteServicos : setorExecutantesServicos) {
            if (setorExecutanteServicos.getPreServicoProcedimentos() != null && !setorExecutanteServicos.getPreServicoProcedimentos().isEmpty()) continue;
            return false;
        }
        return true;
    }

    Boolean validaPreProcedimentos(List<SetorExecutanteServicos> setorExecutantesServicos) {
        for (SetorExecutanteServicos setorExecutanteServicos : setorExecutantesServicos) {
            for (PreServicoProcedimento preServicoProcedimento : setorExecutanteServicos.getPreServicoProcedimentos()) {
                for (PreProcedimento preProcedimento : preServicoProcedimento.getPreProcedimento()) {
                    if (preProcedimento.getDescricao() != null && !preProcedimento.getDescricao().isEmpty()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String getSimpleName() {
        return "Plano Manuten\u00e7\u00e3o";
    }
}

