/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.projeto;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Projeto;
import com.touchcomp.basementor.model.vo.ProjetoParticipante;
import com.touchcomp.basementor.model.vo.ProjetoRecursos;
import com.touchcomp.basementor.model.vo.ProjetoTarefa;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidProjeto
extends ValidGenericEntitiesImpl<Projeto> {
    @Override
    protected void isValid(Projeto vo) {
        this.valid(this.code("V.ERP.1266.001", "descricao"), vo.getDescricao());
        this.valid(this.code("V.ERP.1266.002", "pessoa"), vo.getPessoa());
        this.valid(this.code("V.ERP.1266.003", "empresa"), vo.getEmpresa());
        this.valid(this.code("V.ERP.1266.004", "dataInicial"), vo.getDataInicial());
        this.valid(this.code("V.ERP.1266.005", "dataFinal"), vo.getDataFinal());
        this.valid(this.code("V.ERP.1266.006", "desistenciaProjeto"), vo.getDesistenciaProjeto());
        if (this.isEquals(vo.getDesistenciaProjeto(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.valid(this.code("V.ERP.1266.007", "motivoDesistencia"), vo.getMotivoDesistencia());
            this.valid(this.code("V.ERP.1266.008", "dataDesistencia"), vo.getDataDesistencia());
            this.valid(this.code("V.ERP.1266.009", "obsDesistencia"), vo.getObsDesistencia());
        }
        this.valid(this.code("V.ERP.1266.010", "pessoaResponsavel"), vo.getPessoaResponsavel());
        this.valid(this.code("V.ERP.1266.011", "classificacaoProjeto"), vo.getClassificacaoProjeto());
        if (this.valid(this.code("V.ERP.1266.012", "participantesProjeto"), (Object)vo.getParticipantesProjeto())) {
            this.validarParticipantes(vo);
        }
        if (this.valid(this.code("V.ERP.1266.013", "tarefas"), (Object)vo.getTarefas())) {
            this.validarTarefas(vo);
        }
        if (this.valid(this.code("V.ERP.1266.014", "recursos"), (Object)vo.getRecursos())) {
            this.validarRecursos(vo);
        }
        this.valid(this.code("V.ERP.1266.015", "dependencias"), (Object)vo.getDependencias());
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validarParticipantes(Projeto vo) {
        for (ProjetoParticipante pp : vo.getParticipantesProjeto()) {
            this.valid(this.code("V.ERP.1266.016", "participante"), pp.getParticipante());
            this.valid(this.code("V.ERP.1266.017", "tipoPessoaProjeto"), pp.getTipoPessoaProjeto());
        }
    }

    private void validarTarefas(Projeto vo) {
        int currentIndex = 0;
        for (ProjetoTarefa tt : vo.getTarefas()) {
            this.valid(this.code("V.ERP.1266.021", "codigoTarefa"), tt.getCodigoTarefa());
            this.valid(this.code("V.ERP.1266.027", "codigoTarefa"), ToolString.onlyNumbers((String)tt.getCodigoTarefa()));
            this.valid(this.code("V.ERP.1266.025", "descricaoTarefa"), tt.getDescricao());
            this.valid(this.code("V.ERP.1266.022", "statusTarefa"), tt.getStatusTarefa());
            this.valid(this.code("V.ERP.1266.023", "dataInicialTarefa"), tt.getDataInicial());
            this.valid(this.code("V.ERP.1266.024", "dataFinalTarefa"), tt.getDataFinal());
            this.valid(this.code("V.ERP.1266.028", "indice"), tt.getIndice());
            this.valid(this.code("V.ERP.1266.029", "percentualAndamento"), tt.getPercentualAndamento());
            if (tt.getIndice() - currentIndex != 0) {
                this.addError(this.code("V.ERP.1266.030", "indice"), tt.getDescricao());
            }
            ++currentIndex;
        }
    }

    private void validarRecursos(Projeto vo) {
        for (ProjetoRecursos r : vo.getRecursos()) {
            this.valid(this.code("V.ERP.1266.019", "codigoRecurso"), r.getCodigoRecurso());
            this.valid(this.code("V.ERP.1266.026", "descricaoRecurso"), r.getDescricao());
        }
    }
}

