/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.requisicao;

import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidRequisicao
extends ValidGenericEntitiesImpl<Requisicao> {
    private boolean validarQuantidade = true;

    @Override
    public void isValid(Requisicao vo) {
        this.valid(this.code("V.ERP.289.001"), vo.getDataRequisicao());
        if (this.validNotEmpty(this.code("V.ERP.289.003"), vo.getItensRequisicao())) {
            vo.getItensRequisicao().forEach(i -> this.validItemRequisicao((ItemRequisicao)i));
        }
    }

    public void validItemRequisicao(ItemRequisicao vo) {
        this.valid(this.code("V.ERP.289.004"), vo.getProduto());
        this.valid(this.code("V.ERP.289.005", vo.getProduto()), vo.getCentroEstoque());
        this.valid(this.code("V.ERP.289.006", vo.getProduto()), vo.getCentroCusto());
        this.valid(this.code("V.ERP.289.007", vo.getProduto()), vo.getNaturezaRequisicao());
        if (this.validNotEmpty(this.code("V.ERP.289.008", vo.getProduto()), vo.getGradeItemRequisicao())) {
            vo.getGradeItemRequisicao().forEach(i -> {
                if ((ToolMethods.isNull((Object)i.getQuantidade()).booleanValue() || i.getQuantidade() <= 0.0) && this.validarQuantidade) {
                    this.valid(this.code("V.ERP.289.009", vo.getProduto()), "");
                }
                this.valid(this.code("V.ERP.289.010", vo.getProduto()), i.getLoteFabricacao());
                this.valid(this.code("V.ERP.289.005", vo.getProduto()), i.getCentroEstoque());
                this.valid(this.code("V.ERP.289.011", vo.getProduto()), i.getEmpresa());
                this.valid(this.code("V.ERP.289.001", vo.getProduto()), i.getDataMovimentacao());
            });
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    public void setValidarQuantidade(boolean validarQuantidade) {
        this.validarQuantidade = validarQuantidade;
    }
}

