/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.roteiroproducao;

import com.touchcomp.basementor.model.vo.FichaTecRoteiroProducao;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementor.model.vo.RoteiroProducaoGrCor;
import com.touchcomp.basementor.model.vo.RoteiroProducaoTpProdSped;
import com.touchcomp.basementor.model.vo.ValorFichaTecRotProducao;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.roteiroproducao.ValidFasesProdutiva;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ValidRoteiroProducao
extends ValidGenericEntitiesImpl<RoteiroProducao> {
    ValidFasesProdutiva validFaseProd;

    public ValidRoteiroProducao(ValidFasesProdutiva validFaseProd) {
        this.validFaseProd = validFaseProd;
    }

    @Override
    protected void isValid(RoteiroProducao entity) {
        this.valid(this.code("V.ERP.0129.001", "descricao"), entity.getDescricao());
        if (!TMethods.isWithData((Collection)entity.getRoteiroProducaoGrCor()) && !TMethods.isWithData((Collection)entity.getGrupoProdutos())) {
            this.addError(this.code("V.ERP.0129.002", "fasesProdutivas"), entity.getRoteiroProducaoGrCor());
        }
        if (TMethods.isWithData((Collection)entity.getRoteiroProducaoGrCor())) {
            this.validItensGradeCor(entity);
        }
        if (TMethods.isWithData((Collection)entity.getGrupoProdutos())) {
            // empty if block
        }
        if (this.validNotEmpty(this.code("V.ERP.0129.003", "fasesProdutivas"), entity.getFasesProdutivas())) {
            this.validItensFasesProdutivas(entity);
        }
        if (this.validNotEmpty(this.code("V.ERP.0129.004", "tiposProducaoSped"), entity.getTiposProducaoSped())) {
            this.validTipoProducaoSped(entity);
        }
        if (TMethods.isWithData((Collection)entity.getFichasTecnicas())) {
            this.validFichaTecRotProducao(entity);
        }
    }

    @Override
    public String getSimpleName() {
        return "1384";
    }

    private void validItensGradeCor(RoteiroProducao entity) {
        for (RoteiroProducaoGrCor tt : entity.getRoteiroProducaoGrCor()) {
            this.valid(this.code("V.ERP.0129.005", "gradeCor"), tt.getGradeCor());
        }
    }

    private void validTipoProducaoSped(RoteiroProducao entity) {
        for (RoteiroProducaoTpProdSped tt : entity.getTiposProducaoSped()) {
            this.valid(this.code("V.ERP.0129.006", "tipoProducaoSped"), tt.getTipoProducaoSped());
        }
    }

    private void validItensFasesProdutivas(RoteiroProducao vo) {
        long count = vo.getFasesProdutivas().stream().filter(i -> TMethods.isAffirmative((Number)i.getAtivo())).count();
        if (count == 0L && TMethods.isAffirmative((Number)vo.getAtivo())) {
            this.addError(this.code("V.ERP.0129.007", "fasesProdutivas"), vo);
        }
        this.validFaseProd.valid((ValidGenericEntitiesImpl)this.validFaseProd, vo.getFasesProdutivas());
    }

    private void validFichaTecRotProducao(RoteiroProducao vo) {
        for (FichaTecRoteiroProducao ficha : vo.getFichasTecnicas()) {
            this.valid(this.code("V.ERP.0129.015"), ficha.getModeloFichaTecnica());
            if (ficha.getModeloFichaTecnica() == null) {
                return;
            }
            this.validNotEmpty(this.code("V.ERP.0129.016"), ficha.getValoresFichaTec());
            if (ficha.getValoresFichaTec() == null) continue;
            for (ValorFichaTecRotProducao vlrFic : ficha.getValoresFichaTec()) {
                if (!this.isAffirmative(vlrFic.getValorObrigatorio())) continue;
                if (ToolString.isADoubleNumber((String)vlrFic.getValor())) {
                    this.validGreather0(this.code("V.ERP.0129.018"), Double.parseDouble(vlrFic.getValor()));
                    continue;
                }
                this.valid(this.code("V.ERP.0129.017", vlrFic.getChave()), vlrFic.getValor());
            }
        }
    }
}

