/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.tabelaprecopromocoes;

import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoes;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesEmp;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesProd;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesProdQtd;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ValidTabelaPrecoPromocoes
extends ValidGenericEntitiesImpl<TabelaPrecoPromocoes> {
    @Override
    protected void isValid(TabelaPrecoPromocoes vo) {
        this.valid(this.code("V.ERP.1986.001"), vo.getDataCadastro());
        this.valid(this.code("V.ERP.1986.002"), vo.getDescricao());
        if (this.valid(this.code("V.ERP.1986.004"), (Object)vo.getEmpresas())) {
            this.validEmpresas(vo.getEmpresas());
        }
        if (this.valid(this.code("V.ERP.1986.005"), (Object)vo.getProdutos())) {
            this.validProdutos(vo.getProdutos());
        }
        this.valid(this.code("V.ERP.1986.006"), vo.getDataInicial());
        this.valid(this.code("V.ERP.1986.007"), vo.getDataFinal());
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    private void validProdutos(List<TabelaPrecoPromocoesProd> produtos) {
        for (TabelaPrecoPromocoesProd prod : produtos) {
            this.valid(this.code("V.ERP.1986.006"), prod.getProduto());
            if (!TMethods.isWithData((Number)prod.getValorVenda())) continue;
            this.valid(this.code("V.ERP.1986.008"), prod.getValorMinimo());
            this.valid(this.code("V.ERP.1986.009"), prod.getValorMaximo());
            this.validPromocaoProdQtd(prod);
        }
    }

    private void validPromocaoProdQtd(TabelaPrecoPromocoesProd prod) {
        if (TMethods.isWithData((Collection)prod.getTabelaPrecoPromocoesProdQtd())) {
            for (TabelaPrecoPromocoesProdQtd pq : prod.getTabelaPrecoPromocoesProdQtd()) {
                this.validGreather0(this.code("V.ERP.1986.010", String.valueOf(prod.getProduto())), pq.getQuantidadeInicial());
                this.validGreather0(this.code("V.ERP.1986.011", String.valueOf(prod.getProduto())), pq.getQuantidadeFinal());
                this.validGreather0(this.code("V.ERP.1986.014", String.valueOf(prod.getProduto())), pq.getValor());
                if (pq.getQuantidadeInicial() == null || pq.getQuantidadeFinal() == null) continue;
                this.validMin(this.code("V.ERP.1986.012", String.valueOf(prod.getProduto())), pq.getQuantidadeFinal(), pq.getQuantidadeInicial() + 0.1);
                for (TabelaPrecoPromocoesProdQtd pqAux : prod.getTabelaPrecoPromocoesProdQtd()) {
                    if (pqAux.getQuantidadeInicial() == null || pqAux.getQuantidadeFinal() == null || TMethods.isEquals((Object)pq.getQuantidadeInicial(), (Object)pqAux.getQuantidadeInicial()) || TMethods.isEquals((Object)pq.getQuantidadeFinal(), (Object)pqAux.getQuantidadeFinal()) || !(pq.getQuantidadeInicial() >= pqAux.getQuantidadeInicial() && pq.getQuantidadeInicial() <= pqAux.getQuantidadeFinal()) && (!(pq.getQuantidadeFinal() >= pqAux.getQuantidadeInicial()) || !(pq.getQuantidadeFinal() <= pqAux.getQuantidadeFinal()))) continue;
                    this.addError(this.code("V.ERP.1986.013", String.valueOf(prod.getProduto())), pq);
                }
            }
        }
    }

    private void validEmpresas(List<TabelaPrecoPromocoesEmp> empresas) {
        for (TabelaPrecoPromocoesEmp emp : empresas) {
            this.valid(this.code("V.ERP.1986.007"), emp.getEmpresa());
        }
    }
}

