/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.titulo;

import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGeneric;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.ValidMessages;
import com.touchcomp.basementorvalidator.entities.impl.lancamentoctbgerencial.ValidLancamentoCtbGerencial;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ValidTitulo
extends ValidGenericEntitiesImpl<Titulo> {
    private ValidGeneric<LancamentoCtbGerencial> validLancamento;
    private OpcoesGerenciais opGerenciais;

    public ValidTitulo(ValidGeneric<LancamentoCtbGerencial> validLancamento) {
        this.validLancamento = validLancamento;
    }

    public ValidTitulo() {
        if (ToolMethods.isNull(this.validLancamento).booleanValue()) {
            this.validLancamento = new ValidLancamentoCtbGerencial();
        }
    }

    public ValidTitulo(OpcoesGerenciais og) {
        this.opGerenciais = og;
        if (ToolMethods.isNull(this.validLancamento).booleanValue()) {
            this.validLancamento = new ValidLancamentoCtbGerencial();
        }
    }

    @Override
    protected void isValid(Titulo entity) {
        this.valid(this.code("V.ERP.0316.001", "pessoa"), entity.getPessoa());
        this.valid(this.code("V.ERP.0316.002", "pagRec"), entity.getPagRec());
        this.valid(this.code("V.ERP.0316.003", "provisao"), entity.getProvisao());
        this.valid(this.code("V.ERP.0316.004", "dataEmissao"), entity.getDataEmissao());
        this.valid(this.code("V.ERP.0316.005", "dataCompetencia"), entity.getDataCompetencia());
        this.valid(this.code("V.ERP.0316.006", "dataVencimento"), entity.getDataVencimento());
        this.valid(this.code("V.ERP.0316.007", "dataVencimentoBase"), entity.getDataVencimentoBase());
        this.validGreather0(this.code("V.ERP.0316.008", "V.ERP.alor"), entity.getValor());
        this.valid(this.code("V.ERP.0316.009", "tipoDoc"), entity.getTipoDoc());
        this.valid(this.code("V.ERP.0316.010", "planoConta"), entity.getPlanoConta());
        this.valid(this.code("V.ERP.0316.011", "numeroParcelas"), entity.getNumeroParcelas());
        this.valid(this.code("V.ERP.0316.012", "numParcTituloEstnota"), entity.getNumParcTituloEstnota());
        this.valid(this.code("V.ERP.0316.013", "carteiraCobranca"), entity.getCarteiraCobranca());
        if (this.validNotEmpty(this.code("V.ERP.0316.014", "lancCtbGerencial"), entity.getLancCtbGerencial())) {
            this.validCollection(entity.getLancCtbGerencial(), "lancCtbGerencial");
        }
        this.validarValorLancamentogerencial(entity);
        this.validarValorLancamentoContabil(entity);
    }

    @Override
    public String getSimpleName() {
        return "316";
    }

    private void validCollection(List<LancamentoCtbGerencial> lancCtbGerencial, String string) {
        lancCtbGerencial.forEach(i -> {
            this.validLancamento.isValidData((LancamentoCtbGerencial)i);
            this.getContainer().getItens().addAll(this.validLancamento.getContainer().getItens());
        });
    }

    @Override
    public void clearContainer() {
        super.clearContainer();
        this.validLancamento.clearContainer();
    }

    private void validarValorLancamentogerencial(Titulo tit) {
        if (!ToolMethods.isNull((Object)this.opGerenciais).booleanValue() && !this.isEquals(this.opGerenciais.getUtilizaContabilidadeGerencial(), (short)1)) {
            return;
        }
        Double valorDeb = tit.getLancCtbGerencial().stream().filter(l -> this.isEquals(l.getDebCred(), EnumLancamentoCTBGerencial.DEBITO.getValue())).map(l2 -> l2.getValor()).collect(Collectors.summingDouble(Double::doubleValue));
        Double valorCred = tit.getLancCtbGerencial().stream().filter(l -> this.isEquals(l.getDebCred(), EnumLancamentoCTBGerencial.CREDITO.getValue())).map(l2 -> l2.getValor()).collect(Collectors.summingDouble(Double::doubleValue));
        valorDeb = ToolFormatter.arrredondarNumero((Double)valorDeb, (int)2);
        valorCred = ToolFormatter.arrredondarNumero((Double)valorCred, (int)2);
        Double diferenca = ToolFormatter.arrredondarNumero((Double)(valorDeb - valorCred), (int)2);
        Double valorTitulo = ToolFormatter.arrredondarNumero((Double)tit.getValor(), (int)2);
        if (Math.abs(valorTitulo - Math.abs(diferenca)) > 0.0) {
            String[] v = new String[]{ToolFormatter.formataNumero((Number)Math.abs(diferenca), (int)2), ToolFormatter.formataNumero((Number)valorTitulo, (int)2)};
            this.addError(new ValidMessages.Code("E.ERP.0316.002", new Object[]{v}), tit);
        }
    }

    private void validarValorLancamentoContabil(Titulo tit) {
        if (tit.getLoteAdLancamentos() == null) {
            return;
        }
        Double valor = ToolFormatter.arrredondarNumero((Double)tit.getLoteAdLancamentos().getLancamentos().stream().mapToDouble(Lancamento::getValor).sum(), (int)2);
        Double valorTitulo = ToolFormatter.arrredondarNumero((Double)tit.getValor(), (int)2);
        if (Math.abs(valorTitulo - Math.abs(valor)) > 0.0) {
            String[] v = new String[]{ToolFormatter.formataNumero((Number)Math.abs(valor), (int)2), ToolFormatter.formataNumero((Number)valorTitulo, (int)2)};
            this.addError(new ValidMessages.Code("E.ERP.0316.003", new Object[]{v}), tit);
        }
    }
}

