/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.usuariobasico;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementor.model.vo.UsuarioEmpresa;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.impl.usuariobasico.ValidLogin;
import org.springframework.stereotype.Component;

@Component
public class ValidUsuarioBasico
extends ValidGenericEntitiesImpl<UsuarioBasico> {
    private ValidLogin validLogin;

    public ValidUsuarioBasico(ValidLogin validLogin) {
        this.validLogin = validLogin;
    }

    @Override
    protected void isValid(UsuarioBasico vo) {
        if (this.valid(this.code("V.ERP.1945.002", "pessoa"), vo.getPessoa())) {
            if (!TMethods.isEquals((Object)vo.getPessoa().getComplemento().getCnpj(), (Object)"00000000000000")) {
                this.valid(this.code("V.ERP.1945.010", "pessoa"), vo.getPessoa().getComplemento().getCnpj());
            }
            if (!this.isAffirmative(vo.getPessoa().getAtivo()) && this.isAffirmative(vo.getAtivo())) {
                this.addError(this.code("V.ERP.1945.013", "pessoa"), vo.getAtivo());
            }
        }
        if (this.valid(this.code("V.ERP.1945.001", "pessoa"), vo.getLogin())) {
            this.valid((ValidGenericEntitiesImpl)this.getValidLogin(), (InterfaceVO)vo.getLogin());
        }
        if (this.valid(this.code("V.ERP.1945.003", "empresas"), (Object)vo.getEmpresas())) {
            for (UsuarioEmpresa usuEmp : vo.getEmpresas()) {
                this.valid(this.code("V.ERP.1945.004", "empresa"), usuEmp.getEmpresa());
                this.valid(this.code("V.ERP.1945.005", "grupo"), usuEmp.getGrupo());
            }
        }
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    public ValidLogin getValidLogin() {
        return this.validLogin;
    }

    public void setValidLogin(ValidLogin validLogin) {
        this.validLogin = validLogin;
    }
}

