/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.entities.impl.wmssaidaestoque;

import com.touchcomp.basementor.model.vo.WmsSaidaEstoque;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoqueGrade;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoqueItem;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import org.springframework.stereotype.Component;

@Component
public class ValidWmsSaidaEstoque
extends ValidGenericEntitiesImpl<WmsSaidaEstoque> {
    @Override
    protected void isValid(WmsSaidaEstoque vo) {
        this.valid(this.code("V.ERP.1913.001", "empresa"), vo.getEmpresa());
        this.valid(this.code("V.ERP.1913.002", "dataSaida"), vo.getDataSaida());
        if (this.validNotEmpty(this.code("V.ERP.1913.003", "itens"), vo.getItens())) {
            this.validItens(vo);
        }
    }

    private void validItens(WmsSaidaEstoque vo) {
        for (WmsSaidaEstoqueItem item : vo.getItens()) {
            this.valid(this.code("V.ERP.1913.004", "produto"), item.getProduto());
            if (!this.validNotEmpty(this.code("V.ERP.1912.009", item.getProduto()), item.getGrades())) continue;
            this.validGrades(item);
        }
    }

    private void validGrades(WmsSaidaEstoqueItem item) {
        for (WmsSaidaEstoqueGrade vo : item.getGrades()) {
            this.valid(this.code("V.ERP.1913.001", "empresa"), vo.getEmpresa());
            this.valid(this.code("V.ERP.1913.005", "wmsEndereco"), vo.getWmsEndereco());
            this.valid(this.code("V.ERP.1913.008", "loteFabricacao"), vo.getLoteFabricacao());
            this.valid(this.code("V.ERP.1913.009", "gradeCor"), vo.getGradeCor());
            this.valid(this.code("V.ERP.1912.008", "quantidade"), vo.getQuantidade());
            this.valid(this.code("V.ERP.1913.002", "dataSaida"), vo.getDataSaida());
        }
    }

    @Override
    public String getSimpleName() {
        return "wms saida";
    }
}

