/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.others.cpfcnpj;

import br.com.caelum.stella.validation.CNPJValidator;
import br.com.caelum.stella.validation.CPFValidator;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;

public class ValidadeCPFCNPJ {
    public static boolean isValid(String cpfCnpj) {
        if (cpfCnpj == null || cpfCnpj.length() == 0) {
            return false;
        }
        String aux = ToolString.onlyNumbers((String)cpfCnpj);
        if (aux.length() <= 11) {
            return ValidadeCPFCNPJ.isValideCPF(aux);
        }
        return ValidadeCPFCNPJ.isValidCnpj(aux);
    }

    public static boolean isCPFCNPJ(String cpfCnpj) {
        if (cpfCnpj == null || cpfCnpj.length() == 0) {
            return false;
        }
        String aux = ToolString.onlyNumbers((String)cpfCnpj);
        if (aux.length() == 11) {
            return ValidadeCPFCNPJ.isValideCPF(aux);
        }
        if (aux.length() == 14) {
            return ValidadeCPFCNPJ.isValidCnpj(aux);
        }
        return false;
    }

    public static boolean isValideCPF(String cpfCnpj) {
        CPFValidator validator = new CPFValidator();
        return validator.invalidMessagesFor(cpfCnpj).isEmpty();
    }

    public static boolean isValidCnpj(String cpfCnpj) {
        CNPJValidator validator = new CNPJValidator();
        return validator.invalidMessagesFor(cpfCnpj).isEmpty();
    }

    public static boolean validarRaizCnpj(String cnpj1, String cnpj2) {
        if (cnpj1 == null || cnpj2 == null) {
            return false;
        }
        if (cnpj1.trim().length() != 14 || cnpj2.trim().length() != 14) {
            return false;
        }
        cnpj1 = cnpj1.substring(0, 8);
        cnpj2 = cnpj2.substring(0, 8);
        return ToolMethods.isEquals((Object)cnpj1, (Object)cnpj2);
    }

    public static String getBaseCNPJ(String cnpj) {
        if (cnpj == null || !ValidadeCPFCNPJ.isValidCnpj(cnpj)) {
            return null;
        }
        cnpj = ToolString.onlyNumbers((String)cnpj);
        cnpj = ToolString.completaZeros((String)cnpj, (int)14, (boolean)true);
        return cnpj.substring(0, 8);
    }

    public static boolean isCNPJ(String cnpj) {
        if (cnpj == null) {
            return false;
        }
        cnpj = TString.onlyNumbers((String)cnpj);
        return ValidadeCPFCNPJ.isValidCnpj(cnpj);
    }
}

