/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorvalidator.others.inscricaoestadual;

import br.com.caelum.stella.validation.ie.IEAcreValidator;
import br.com.caelum.stella.validation.ie.IEAlagoasValidator;
import br.com.caelum.stella.validation.ie.IEAmapaValidator;
import br.com.caelum.stella.validation.ie.IEAmazonasValidator;
import br.com.caelum.stella.validation.ie.IEBahiaValidator;
import br.com.caelum.stella.validation.ie.IECearaValidator;
import br.com.caelum.stella.validation.ie.IEDistritoFederalValidator;
import br.com.caelum.stella.validation.ie.IEEspiritoSantoValidator;
import br.com.caelum.stella.validation.ie.IEGoiasValidator;
import br.com.caelum.stella.validation.ie.IEMaranhaoValidator;
import br.com.caelum.stella.validation.ie.IEMatoGrossoDoSulValidator;
import br.com.caelum.stella.validation.ie.IEMatoGrossoValidator;
import br.com.caelum.stella.validation.ie.IEMinasGeraisValidator;
import br.com.caelum.stella.validation.ie.IEParaValidator;
import br.com.caelum.stella.validation.ie.IEParaibaValidator;
import br.com.caelum.stella.validation.ie.IEParanaValidator;
import br.com.caelum.stella.validation.ie.IEPernambucoValidator;
import br.com.caelum.stella.validation.ie.IEPiauiValidator;
import br.com.caelum.stella.validation.ie.IERioDeJaneiroValidator;
import br.com.caelum.stella.validation.ie.IERioGrandeDoNorteValidator;
import br.com.caelum.stella.validation.ie.IERioGrandeDoSulValidator;
import br.com.caelum.stella.validation.ie.IERondoniaValidator;
import br.com.caelum.stella.validation.ie.IERoraimaValidator;
import br.com.caelum.stella.validation.ie.IESantaCatarinaValidator;
import br.com.caelum.stella.validation.ie.IESaoPauloValidator;
import br.com.caelum.stella.validation.ie.IESergipeValidator;
import br.com.caelum.stella.validation.ie.IETocantinsValidator;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.text.ParseException;
import javax.swing.text.MaskFormatter;

public class ValidateInscricaoEstadual {
    public static boolean isValid(String ie, EnumConstUF uf) {
        if (uf == null) {
            return false;
        }
        if (ie == null || ie.length() == 0) {
            return false;
        }
        ie = ToolString.onlyNumbers((String)ie);
        try {
            switch (uf) {
                case AC: {
                    new IEAcreValidator(false).assertValid(ie);
                    break;
                }
                case AL: {
                    new IEAlagoasValidator(false).assertValid(ie);
                    break;
                }
                case AM: {
                    new IEAmazonasValidator(false).assertValid(ie);
                    break;
                }
                case AP: {
                    new IEAmapaValidator(false).assertValid(ie);
                    break;
                }
                case BA: {
                    new IEBahiaValidator(false).assertValid(ie);
                    break;
                }
                case CE: {
                    new IECearaValidator(false).assertValid(ie);
                    break;
                }
                case DF: {
                    new IEDistritoFederalValidator(false).assertValid(ie);
                    break;
                }
                case ES: {
                    new IEEspiritoSantoValidator(false).assertValid(ie);
                    break;
                }
                case GO: {
                    new IEGoiasValidator(false).assertValid(ie);
                    break;
                }
                case MA: {
                    new IEMaranhaoValidator(false).assertValid(ie);
                    break;
                }
                case MG: {
                    new IEMinasGeraisValidator(false).assertValid(ie);
                    break;
                }
                case MS: {
                    new IEMatoGrossoDoSulValidator(false).assertValid(ie);
                    break;
                }
                case MT: {
                    new IEMatoGrossoValidator(false).assertValid(ie);
                    break;
                }
                case PA: {
                    new IEParaValidator(false).assertValid(ie);
                    break;
                }
                case PB: {
                    new IEParaibaValidator(false).assertValid(ie);
                    break;
                }
                case PE: {
                    new IEPernambucoValidator(false).assertValid(ie);
                    break;
                }
                case PI: {
                    new IEPiauiValidator(false).assertValid(ie);
                    break;
                }
                case PR: {
                    new IEParanaValidator(false).assertValid(ie);
                    break;
                }
                case RJ: {
                    new IERioDeJaneiroValidator(false).assertValid(ie);
                    break;
                }
                case RN: {
                    new IERioGrandeDoNorteValidator(false).assertValid(ie);
                    break;
                }
                case RO: {
                    new IERondoniaValidator(false).assertValid(ie);
                    break;
                }
                case RR: {
                    new IERoraimaValidator(false).assertValid(ie);
                    break;
                }
                case RS: {
                    new IERioGrandeDoSulValidator(false).assertValid(ie);
                    break;
                }
                case SC: {
                    new IESantaCatarinaValidator(false).assertValid(ie);
                    break;
                }
                case SE: {
                    new IESergipeValidator(false).assertValid(ie);
                    break;
                }
                case SP: {
                    new IESaoPauloValidator(false).assertValid(ie);
                    break;
                }
                case TO: {
                    new IETocantinsValidator(false).assertValid(ie);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String formatIE(String ie, EnumConstUF uf) throws ExceptionParseObject {
        try {
            if (uf == null) {
                return null;
            }
            if (ie == null || ie.length() == 0) {
                return null;
            }
            ie = ToolString.onlyNumbers((String)ie);
            int size = 0;
            String strMask = "";
            switch (uf) {
                case AC: {
                    size = 13;
                    strMask = "##.###.###/###-##";
                    break;
                }
                case AL: {
                    size = 10;
                    strMask = "##########";
                    break;
                }
                case AM: {
                    size = 9;
                    strMask = "##.###.###-#";
                    break;
                }
                case AP: {
                    size = 9;
                    strMask = "#########";
                    break;
                }
                case BA: {
                    size = 8;
                    strMask = "######-##";
                    break;
                }
                case CE: {
                    size = 8;
                    strMask = "########-#";
                    break;
                }
                case DF: {
                    size = 13;
                    strMask = "###########-##";
                    break;
                }
                case ES: {
                    size = 9;
                    strMask = "########-#";
                    break;
                }
                case GO: {
                    size = 9;
                    strMask = "##.###.###-#";
                    break;
                }
                case MA: {
                    size = 8;
                    strMask = "########-#";
                    break;
                }
                case MG: {
                    size = 13;
                    strMask = "###.###.###/####";
                    break;
                }
                case MS: {
                    size = 9;
                    strMask = "########-#";
                    break;
                }
                case MT: {
                    size = 11;
                    strMask = "##########-#";
                    break;
                }
                case PA: {
                    size = 9;
                    strMask = "##-######-#";
                    break;
                }
                case PB: {
                    size = 9;
                    strMask = "########-#";
                    break;
                }
                case PE: {
                    size = 9;
                    strMask = "#######-##";
                    break;
                }
                case PI: {
                    size = 9;
                    strMask = "########-#";
                    break;
                }
                case PR: {
                    size = 10;
                    strMask = "###.#####-##";
                    break;
                }
                case RJ: {
                    size = 8;
                    strMask = "##.###.##-#";
                    break;
                }
                case RN: {
                    size = 9;
                    strMask = "##.###.###-#";
                    break;
                }
                case RO: {
                    size = 14;
                    strMask = "#############-#";
                    break;
                }
                case RR: {
                    size = 9;
                    strMask = "########-#";
                    break;
                }
                case RS: {
                    size = 10;
                    strMask = "###/#######";
                    break;
                }
                case SC: {
                    size = 9;
                    strMask = "###.###.###";
                    break;
                }
                case SE: {
                    size = 9;
                    strMask = "########-#";
                    break;
                }
                case SP: {
                    size = 12;
                    strMask = "###.###.###.###";
                    break;
                }
                case TO: {
                    size = 11;
                    strMask = "##########-#";
                    break;
                }
            }
            MaskFormatter mask = new MaskFormatter(strMask);
            mask.setValueContainsLiteralCharacters(false);
            ie = ToolString.completaZerosEsquerda((String)ie, (int)size);
            return mask.valueToString(ie);
        }
        catch (ParseException ex) {
            throw new ExceptionParseObject(ex, new Object[]{ie});
        }
    }
}

