/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorxml;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorxml.model.ArquivamentoDadosDoc;
import com.touchcomp.basementorxml.model.XMLCTe;
import com.touchcomp.basementorxml.model.XMLDpec;
import com.touchcomp.basementorxml.model.XMLEventoCTe;
import com.touchcomp.basementorxml.model.XMLEventoCancelamentoManifestoCte;
import com.touchcomp.basementorxml.model.XMLEventoEncerramentoManifestoCte;
import com.touchcomp.basementorxml.model.XMLEventoEsocial;
import com.touchcomp.basementorxml.model.XMLEventoNFe;
import com.touchcomp.basementorxml.model.XMLManifestoCte;
import com.touchcomp.basementorxml.model.XMLNFCe;
import com.touchcomp.basementorxml.model.XMLNFeCTe;
import com.touchcomp.basementorxml.model.XMLNFeCTeEvt;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import com.touchcomp.basementorxml.model.XMLNfeTerceiros;
import com.touchcomp.basementorxml.model.XMLNfseRPS;
import java.util.LinkedList;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class ConfHibernateXML {
    private static final TLogger logger = TLogger.get(ConfHibernateXML.class);
    @Autowired
    private Environment environment;
    private static String urlConexaoLocal;
    private static String dbUserLocal;
    private static String dbPassLocal;
    private static String dbDriverLocal;
    private static String showSQLLocal;

    @Bean
    public LocalSessionFactoryBean sessionFactoryXML() throws ExceptionReflection {
        LocalSessionFactoryBean sessionFactory = new LocalSessionFactoryBean();
        sessionFactory.setDataSource(this.dataSourceXML());
        sessionFactory.setAnnotatedClasses(this.getAllClasses());
        sessionFactory.setHibernateProperties(this.getHibernateProps());
        return sessionFactory;
    }

    private Class[] getAllClasses() throws ExceptionReflection {
        LinkedList<Class<XMLNfseRPS>> all = new LinkedList<Class<XMLNfseRPS>>();
        all.add(ArquivamentoDadosDoc.class);
        all.add(XMLCTe.class);
        all.add(XMLDpec.class);
        all.add(XMLEventoCTe.class);
        all.add(XMLEventoCancelamentoManifestoCte.class);
        all.add(XMLEventoEncerramentoManifestoCte.class);
        all.add(XMLEventoEsocial.class);
        all.add(XMLEventoNFe.class);
        all.add(XMLManifestoCte.class);
        all.add(XMLNFCe.class);
        all.add(XMLNFeCTe.class);
        all.add(XMLNFeCTeEvt.class);
        all.add(XMLNfePropria.class);
        all.add(XMLNfeTerceiros.class);
        all.add(XMLNfseRPS.class);
        return all.toArray(new Class[0]);
    }

    private Properties getHibernateProps() {
        Properties properties = new Properties();
        properties.put("hibernate.dialect", this.environment.getRequiredProperty("hibernate.dialect"));
        if (TMethods.isStrWithData((String)showSQLLocal)) {
            properties.put("hibernate.show_sql", showSQLLocal);
        }
        properties.put("hibernate.hbm2ddl.auto", this.environment.getRequiredProperty("hibernate.hbm2ddl.auto"));
        properties.put("hibernate.enable_lazy_load_no_trans", "true");
        properties.put("hibernate.id.new_generator_mappings", "false");
        properties.put("hibernate.event.merge.entity_copy_observer", "allow");
        return properties;
    }

    @Bean
    public DataSource dataSourceXML() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(dbDriverLocal);
        dataSource.setUrl(urlConexaoLocal);
        dataSource.setUsername(dbUserLocal);
        dataSource.setPassword(dbPassLocal);
        return dataSource;
    }

    @Bean(name={"transactionManagerXML"})
    @Autowired
    public HibernateTransactionManager transactionManager(@Qualifier(value="sessionFactoryXML") SessionFactory sessionFactoryXML) {
        HibernateTransactionManager txManager = new HibernateTransactionManager();
        txManager.setSessionFactory(sessionFactoryXML);
        return txManager;
    }

    public static void setConfig(String dbDriver, String urlConexao, String dbUser, String dbPass, String showSQL) {
        urlConexaoLocal = urlConexao;
        dbUserLocal = dbUser;
        dbPassLocal = dbPass;
        dbDriverLocal = dbDriver;
        showSQLLocal = showSQL;
    }
}

