/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.jdbc;

import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.RuntimeJarLoader;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.jdbc.JdbcException;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.jdbc.JdbcStatment;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public class JdbcConnection {
    private final Connection coreConnection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R> R execute(Task<R> task, long timeout, String timeoutMessage) throws TimeoutException, Throwable {
        final TaskResult fResult = new TaskResult();
        final Task<R> fTask = task;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object result = fTask.run();
                    fResult.setResult(result);
                }
                catch (Throwable t) {
                    fResult.setError(t);
                }
                TaskResult taskResult = fResult;
                synchronized (taskResult) {
                    fResult.setComplete(true);
                    fResult.notify();
                }
            }
        };
        TaskResult taskResult = fResult;
        synchronized (taskResult) {
            Thread t = new Thread(runnable);
            t.start();
            fResult.wait(timeout);
            if (!fResult.isComplete()) {
                t.interrupt();
                throw new TimeoutException(timeoutMessage);
            }
            Throwable error = fResult.getError();
            if (error != null) {
                throw error;
            }
            return fResult.getResult();
        }
    }

    public static JdbcConnection getConnection(File jarFile, String driverClassName, String jdbcUrl, String username, String password, long timeout) throws TimeoutException, Throwable {
        final File fJarFile = jarFile;
        final String fDriverClassName = driverClassName;
        final String fUsername = username;
        final String fPassword = password;
        final String fJdbcUrl = jdbcUrl;
        Task<JdbcConnection> connectionTask = new Task<JdbcConnection>(){

            @Override
            public JdbcConnection run() {
                try {
                    RuntimeJarLoader jarLoader = RuntimeJarLoader.getInstance();
                    jarLoader.addFile(fJarFile);
                    Class<?> drvClass = jarLoader.loadClass(fDriverClassName);
                    Driver driver = (Driver)drvClass.newInstance();
                    Properties props = new Properties();
                    props.put("user", fUsername);
                    props.put("password", fPassword);
                    Connection connection = driver.connect(fJdbcUrl, props);
                    return new JdbcConnection(connection);
                }
                catch (Exception e) {
                    throw new JdbcException(e);
                }
            }
        };
        return JdbcConnection.execute(connectionTask, timeout, "Connection timeout");
    }

    public static JdbcConnection getConnection(File jarFile, String driverClassName, String jdbcUrl, String username, String password) throws Throwable {
        return JdbcConnection.getConnection(jarFile, driverClassName, jdbcUrl, username, password, 0L);
    }

    public static JdbcConnection getConnection(String jdbcUrl, String username, String password, long timeout) throws JdbcException, Throwable {
        final String fJdbcUrl = jdbcUrl;
        final String fUsername = username;
        final String fPassword = password;
        Task<JdbcConnection> connectionTask = new Task<JdbcConnection>(){

            @Override
            public JdbcConnection run() {
                try {
                    JdbcConnection conn = new JdbcConnection(DriverManager.getConnection(fJdbcUrl, fUsername, fPassword));
                    return conn;
                }
                catch (SQLException e) {
                    throw new JdbcException(e);
                }
            }
        };
        return JdbcConnection.execute(connectionTask, timeout, "Connection timeout");
    }

    public static JdbcConnection getConnection(String jdbcUrl, String username, String password) throws JdbcException, Throwable {
        return JdbcConnection.getConnection(jdbcUrl, username, password, 0L);
    }

    JdbcConnection(Connection coreConnection) {
        this.coreConnection = coreConnection;
    }

    public final Connection getCoreConnection() {
        return this.coreConnection;
    }

    public boolean getAutoCommit() throws JdbcException {
        try {
            return this.getCoreConnection().getAutoCommit();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws JdbcException {
        try {
            this.getCoreConnection().setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public JdbcStatment prepareStatement(String sql) throws JdbcException {
        try {
            return new JdbcStatment(this.coreConnection.prepareStatement(sql), this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void close() throws JdbcException {
        try {
            this.getCoreConnection().close();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public boolean isOpen() {
        try {
            return !this.getCoreConnection().isClosed();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getTableNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try {
            DatabaseMetaData md = this.getCoreConnection().getMetaData();
            ResultSet rs = md.getTables(null, null, "%", null);
            while (rs.next()) {
                result.add(rs.getString(3));
            }
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
        return Collections.unmodifiableSet(result);
    }

    private static class TaskResult<R> {
        private boolean complete = false;
        private R result = null;
        private Throwable error = null;

        public synchronized boolean isComplete() {
            return this.complete;
        }

        public synchronized void setComplete(boolean complete) {
            this.complete = complete;
        }

        public synchronized R getResult() {
            return this.result;
        }

        public synchronized void setResult(R result) {
            this.result = result;
        }

        public synchronized Throwable getError() {
            return this.error;
        }

        public synchronized void setError(Throwable error) {
            this.error = error;
        }

        private TaskResult() {
        }
    }

    private static interface Task<R> {
        public R run();
    }

    public static class TimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TimeoutException(String message) {
            super(message);
        }
    }
}

