/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.jdbc;

import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.jdbc.JdbcConnection;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.jdbc.JdbcException;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.jdbc.JdbcResultSet;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public class JdbcStatment {
    private final PreparedStatement coreStmt;
    private final JdbcConnection connection;

    JdbcStatment(PreparedStatement coreStmt, JdbcConnection connection) {
        this.coreStmt = coreStmt;
        this.connection = connection;
    }

    public final PreparedStatement getCoreStatement() {
        return this.coreStmt;
    }

    public final JdbcConnection getConnection() {
        return this.connection;
    }

    private void privateSet(int index, Object obj) throws JdbcException {
        try {
            this.getCoreStatement().setObject(index, obj);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void set(int index, Short s) {
        this.privateSet(index, s);
    }

    public void set(int index, Integer i) {
        this.privateSet(index, i);
    }

    public void set(int index, String str) {
        this.privateSet(index, str);
    }

    public void set(int index, Enum<?> e) {
        this.set(index, e.name());
    }

    public void set(int index, Date date) {
        this.privateSet(index, date);
    }

    public JdbcResultSet executeQuery() throws JdbcException {
        try {
            return new JdbcResultSet(this.getCoreStatement().executeQuery(), this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public JdbcResultSet getGeneratedKeys() throws JdbcException {
        try {
            ResultSet rs = this.getCoreStatement().getGeneratedKeys();
            return new JdbcResultSet(rs, this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public boolean isClosed() throws JdbcException {
        try {
            return this.getCoreStatement().isClosed();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public boolean execute() throws JdbcException {
        try {
            return this.getCoreStatement().execute();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void close() throws JdbcException {
        try {
            this.getCoreStatement().close();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }
}

