/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm;

import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.Event;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.Listener;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.AbstractConnection;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.AbstractRawConnection;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.Command;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.CommandBuilder;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.CommandListener;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.ConnectionListener;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.DataBuffer;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.SimpleCommand;
import java.io.IOException;

public class CommandConnection
extends AbstractConnection {
    private static final CommandBuilder DEFAULT_COMMAND_BUILDER = new SimpleCommand.SimpleCommandBuilder();
    public static final Event EVT_COMMAND_READ = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((CommandListener)listener).onCommandRead((CommandConnection)args[0], (Command)args[1]);
        }

        @Override
        public void onEvent(Object ... args) {
            try {
                ((CommandConnection)args[0]).onCommandRead((Command)args[1]);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    };
    public static final Event EVT_COMMAND_WRITE = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((CommandListener)listener).onCommandWrite((CommandConnection)args[0], (Command)args[1]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((CommandConnection)args[0]).onCommandWrite((Command)args[1]);
        }
    };
    private final AbstractRawConnection rawConnection;
    private final ConnectionListener wrapperListener = new ConnectionListener(){

        @Override
        public void onDataRead(AbstractConnection connection, DataBuffer dataBuffer) {
            CommandConnection.this.notifyEvent(AbstractConnection.EVT_DATA_READ, this, dataBuffer);
        }

        @Override
        public void onOpen(AbstractConnection connection) {
            CommandConnection.this.notifyEvent(AbstractConnection.EVT_OPEN, this);
        }

        @Override
        public void onClose(AbstractConnection connection) {
            CommandConnection.this.notifyEvent(AbstractConnection.EVT_CLOSE, this);
        }

        @Override
        public void onDataWrite(AbstractConnection connection, byte[] data) {
            CommandConnection.this.notifyEvent(AbstractConnection.EVT_DATA_WRITE, this, data);
        }

        @Override
        public void onError(AbstractConnection connection, Throwable error) {
            CommandConnection.this.notifyEvent(AbstractConnection.EVT_ERROR, this, error);
        }
    };

    public CommandConnection(AbstractRawConnection rawConnection) {
        super(rawConnection.getEventLoop());
        rawConnection.addListener(this.wrapperListener);
        this.rawConnection = rawConnection;
    }

    @Override
    final void doWrite(byte[] data) throws IOException {
        this.getRawConnection().doWrite(data);
    }

    protected CommandBuilder getCommandBuilder() {
        return DEFAULT_COMMAND_BUILDER;
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this.getCommandBuilder().reset();
    }

    @Override
    protected void onDataRead(DataBuffer dataBuffer) {
        super.onDataRead(dataBuffer);
        CommandBuilder cmdBuilder = this.getCommandBuilder();
        do {
            try {
                if (!cmdBuilder.canBuild(dataBuffer)) continue;
                this.notifyEvent(EVT_COMMAND_READ, this, cmdBuilder.getCommand(dataBuffer));
                cmdBuilder.reset();
            }
            catch (Throwable t) {
                this.notifyEvent(EVT_ERROR, this, t);
            }
        } while (dataBuffer.available() != 0);
    }

    protected void onCommandRead(Command command) {
    }

    protected void onCommandWrite(Command command) {
    }

    public AbstractRawConnection getRawConnection() {
        return this.rawConnection;
    }

    public boolean writeCommand(Command command) {
        try {
            if (command == null) {
                throw new IllegalArgumentException("Command cannot be null");
            }
            command.write(this.getRawConnection().getEffectiveChannel());
            this.notifyEvent(EVT_COMMAND_WRITE, this, command);
            return true;
        }
        catch (Throwable ex) {
            this.notifyEvent(EVT_ERROR, this, ex);
            return false;
        }
    }

    @Override
    public void addListener(CommandListener listener, boolean prepend) {
        super.addListener(listener, prepend);
    }

    @Override
    public final void addListener(CommandListener listener) {
        this.addListener(listener, false);
    }

    @Override
    public final void prependListener(CommandListener listener) {
        this.addListener(listener, true);
    }

    @Override
    public final void addListener(ConnectionListener listener, boolean prepend) {
        CommandListener cmdListener = !(listener instanceof CommandListener) ? new CommandListener.CommandListenerWrapper(listener) : (CommandListener)listener;
        this.addListener(cmdListener, prepend);
    }

    @Override
    public void removeListener(CommandListener listener) {
        super.removeListener(listener);
    }

    @Override
    public final void removeListener(ConnectionListener listener) {
        this.removeListener((CommandListener)listener);
    }

    @Override
    public boolean isOpen() {
        return this.getRawConnection().isOpen();
    }

    @Override
    public void close() {
        this.getRawConnection().close();
    }
}

