/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.thermalprinter;

import com.touchcomp.basementorexceptions.exceptions.impl.hardware.EnumExcepHardware;
import com.touchcomp.basementorexceptions.exceptions.impl.hardware.ExceptionHardware;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.EnumExcepInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementortools.tools.stringformat.ToolStringFormater;
import com.touchcomp.basenativeequipments.thermalprinter.USBConnectedDevices;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotOpenException;
import javax.usb.UsbPipe;
import javax.usb.event.UsbPipeDataEvent;
import javax.usb.event.UsbPipeErrorEvent;
import javax.usb.event.UsbPipeListener;

public abstract class ThermalPrinter {
    private UsbDevice device;
    private boolean configured = false;

    public void configure(String serial) throws IOException, ExceptionInvalidData, ExceptionHardware {
        try {
            if (serial == null || serial.isEmpty()) {
                throw new ExceptionInvalidData(EnumExcepInvalidData.DADOS_INVALIDOS, new Object[]{"Nr. de serie da impressora n\u00c3\u00a3o informado."});
            }
            this.device = USBConnectedDevices.getByNumeroSerie(serial);
            this.configured = true;
        }
        catch (UsbException ex) {
            throw new ExceptionHardware(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ExceptionHardware(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String text, Map<String, String> otherParams) throws ExceptionHardware {
        if (!this.configured) {
            throw new ExceptionHardware(EnumExcepHardware.DISPOSITIVO_NAO_CONFIGURADO, new Object[]{"Impressora/Printer"});
        }
        UsbPipe pipe = null;
        UsbInterface iface = null;
        try {
            UsbConfiguration configuration = this.device.getActiveUsbConfiguration();
            iface = (UsbInterface)configuration.getUsbInterfaces().get(0);
            if (!iface.isClaimed()) {
                iface.claim(usbInterface -> true);
            }
            UsbEndpoint endpoint = (UsbEndpoint)iface.getUsbEndpoints().get(0);
            pipe = endpoint.getUsbPipe();
            pipe.addUsbPipeListener(new UsbPipeListener(){

                public void errorEventOccurred(UsbPipeErrorEvent event) {
                    UsbException error = event.getUsbException();
                    System.out.println(error);
                }

                public void dataEventOccurred(UsbPipeDataEvent event) {
                    byte[] data = event.getData();
                    System.out.println("Size: " + data.length);
                    for (byte b : data) {
                        String s1 = String.format("%8s", Integer.toBinaryString(b & 0xFF)).replace(' ', '0');
                        System.out.println(b + "=" + s1);
                    }
                }
            });
            pipe.open();
            otherParams.putAll(this.getAll());
            text = ToolStringFormater.format((String)text, otherParams);
            pipe.syncSubmit(this.getInitializeCommander());
            pipe.syncSubmit(text.getBytes());
        }
        catch (IllegalArgumentException ex) {
            throw new ExceptionHardware(ex);
        }
        catch (UsbDisconnectedException ex) {
            throw new ExceptionHardware(ex);
        }
        catch (UsbException ex) {
            throw new ExceptionHardware(ex);
        }
        catch (UsbNotActiveException ex) {
            throw new ExceptionHardware(ex);
        }
        catch (UsbNotOpenException ex) {
        }
        finally {
            try {
                if (pipe != null) {
                    pipe.close();
                }
                if (iface != null) {
                    iface.release();
                }
            }
            catch (UsbException ex) {
                Logger.getLogger(ThermalPrinter.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UsbNotActiveException ex) {
                Logger.getLogger(ThermalPrinter.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UsbNotOpenException ex) {
                Logger.getLogger(ThermalPrinter.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UsbDisconnectedException ex) {
                Logger.getLogger(ThermalPrinter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public abstract byte[] getInitializeCommander();

    public abstract HashMap<String, String> getAll();
}

