/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.format;

import br.com.caelum.stella.format.Formatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BaseFormatter
implements Formatter {
    private final Pattern formatted;
    private final String formattedReplacement;
    private final Pattern unformatted;
    private final String unformattedReplacement;

    @Override
    public String format(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Value may not be null.");
        }
        Matcher matcher = this.unformatted.matcher(value);
        String result = this.matchAndReplace(matcher, this.formattedReplacement);
        return result;
    }

    @Override
    public String unformat(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Value may not be null.");
        }
        Matcher unformattedMatcher = this.unformatted.matcher(value);
        if (unformattedMatcher.matches()) {
            return value;
        }
        Matcher matcher = this.formatted.matcher(value);
        String result = this.matchAndReplace(matcher, this.unformattedReplacement);
        return result;
    }

    @Override
    public boolean isFormatted(String value) {
        return this.formatted.matcher(value).matches();
    }

    @Override
    public boolean canBeFormatted(String value) {
        return this.unformatted.matcher(value).matches();
    }

    private String matchAndReplace(Matcher matcher, String replacement) {
        String result = null;
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Value is not properly formatted.");
        }
        result = matcher.replaceAll(replacement);
        return result;
    }

    public BaseFormatter(Pattern formatted, String formattedReplacement, Pattern unformatted, String unformattedReplacement) {
        this.formatted = formatted;
        this.formattedReplacement = formattedReplacement;
        this.unformatted = unformatted;
        this.unformattedReplacement = unformattedReplacement;
    }
}

