/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.inwords;

import br.com.caelum.stella.inwords.FormatoDeDolar;
import br.com.caelum.stella.inwords.FormatoDeExtenso;
import br.com.caelum.stella.inwords.FormatoDeReal;
import br.com.caelum.stella.inwords.Messages;
import java.util.Locale;

public class FormatoDeMoeda
implements FormatoDeExtenso {
    private final FormatoDeExtenso formato;

    public FormatoDeMoeda(Locale locale) {
        if (Locale.US.equals(locale)) {
            this.formato = new FormatoDeDolar();
        } else if (Messages.LOCALE_PT_BR.equals(locale)) {
            this.formato = new FormatoDeReal();
        } else {
            String pais = locale.getDisplayCountry(Messages.LOCALE_PT_BR);
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel determinar a moeda para o pa\u00eds " + pais);
        }
    }

    @Override
    public String getUnidadeDecimalNoSingular() {
        return this.formato.getUnidadeDecimalNoSingular();
    }

    @Override
    public String getUnidadeDecimalNoPlural() {
        return this.formato.getUnidadeDecimalNoPlural();
    }

    @Override
    public String getUnidadeInteiraNoSingular() {
        return this.formato.getUnidadeInteiraNoSingular();
    }

    @Override
    public String getUnidadeInteiraNoPlural() {
        return this.formato.getUnidadeInteiraNoPlural();
    }

    @Override
    public int getCasasDecimais() {
        return this.formato.getCasasDecimais();
    }
}

