/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.DigitoGenerator;
import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import java.util.Random;
import java.util.regex.Pattern;

public class IEGoiasValidator
extends AbstractIEValidator {
    public static final Pattern FORMATED = Pattern.compile("(1[015])[.](\\d{3})[.](\\d{3})[-](\\d{1})");
    public static final Pattern UNFORMATED = Pattern.compile("(1[015])(\\d{3})(\\d{3})(\\d{1})");

    public IEGoiasValidator() {
        super(true);
    }

    public IEGoiasValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IEGoiasValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String unformattedIE) {
        String iESemDigito = unformattedIE.substring(0, unformattedIE.length() - 1);
        String digito = unformattedIE.substring(unformattedIE.length() - 1);
        String digitoCalculado = this.calculaDigito(iESemDigito);
        return this.regraBizarraDeGoias(iESemDigito, digito) || digito.equals(digitoCalculado);
    }

    private boolean regraBizarraDeGoias(String iESemDigito, String digito) {
        return iESemDigito.equals("11094402") && (digito.equals("0") || digito.equals("1"));
    }

    private String calculaDigito(String iESemDigito) {
        int ie = Integer.parseInt(iESemDigito);
        String d = "0";
        if (10103105 <= ie && ie <= 10119997) {
            d = "1";
        }
        return new DigitoPara(iESemDigito).complementarAoModulo().trocandoPorSeEncontrar(d, 10).trocandoPorSeEncontrar("0", 11).calcula();
    }

    @Override
    public String generateRandomValid() {
        int[] segundoDigitosPossiveis = new int[]{0, 1, 5};
        int segundoDigitoSorteado = new Random().nextInt(segundoDigitosPossiveis.length);
        String ieSemDigito = "1" + segundoDigitosPossiveis[segundoDigitoSorteado] + new DigitoGenerator().generate(6);
        String ieComDigitos = ieSemDigito + this.calculaDigito(ieSemDigito);
        if (this.isFormatted) {
            return super.format(ieComDigitos, "##.###.###-#");
        }
        return ieComDigitos;
    }
}

